/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.dropdown.demo.examples;

import java.util.Arrays;
import org.eclipse.rap.addons.autosuggest.AutoSuggest;
import org.eclipse.rap.addons.autosuggest.DataProvider;
import org.eclipse.rap.addons.autosuggest.DataSource;
import org.eclipse.rap.addons.autosuggest.SuggestionSelectedListener;
import org.eclipse.rap.addons.dropdown.demo.examples.CityMap;
import org.eclipse.rap.addons.dropdown.demo.examples.CountryInfo;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DropDownExamplePage
implements IExamplePage {
    private CityMap cityMap;
    private Text countryText;
    private Text cityText;
    private AutoSuggest cityAutoSuggest;
    private CountryInfo.Country currentCountry = null;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)2));
        this.createCitySelection(parent);
        this.createCityMap(parent);
    }

    private void createCitySelection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("City Selection");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.createCountryText((Composite)group);
        this.createCityText((Composite)group);
        this.createCityAutoSuggest();
        this.createCountryAutoSuggest();
    }

    public void createCountryText(Composite parent) {
        Label countryLabel = new Label(parent, 0);
        countryLabel.setText("Country:");
        this.countryText = new Text(parent, 2048);
        this.countryText.setLayoutData((Object)new GridData(300, -1));
        this.countryText.setFocus();
    }

    public void createCityText(Composite parent) {
        Label cityLabel = new Label(parent, 0);
        cityLabel.setText("City:");
        this.cityText = new Text(parent, 2048);
        this.cityText.setLayoutData((Object)new GridData(300, -1));
        this.cityText.setEnabled(false);
    }

    private void createCountryAutoSuggest() {
        AutoSuggest countryAutoSuggest = new AutoSuggest(this.countryText);
        countryAutoSuggest.setAutoComplete(true);
        countryAutoSuggest.setDataSource(DropDownExamplePage.createCountriesDataSource());
        countryAutoSuggest.addSelectionListener(new SuggestionSelectedListener(){

            public void suggestionSelected() {
                DropDownExamplePage.this.setCurrentCountry(DropDownExamplePage.this.countryText.getText());
            }
        });
    }

    private void setCurrentCountry(String name) {
        this.cityText.setText("");
        this.cityText.setEnabled(true);
        this.currentCountry = CountryInfo.getInstance().findCountry(name);
        this.cityAutoSuggest.setDataSource(DropDownExamplePage.createDataSource(this.currentCountry));
    }

    private void createCityAutoSuggest() {
        this.cityAutoSuggest = new AutoSuggest(this.cityText);
        this.cityAutoSuggest.setAutoComplete(true);
        this.cityAutoSuggest.addSelectionListener(new SuggestionSelectedListener(){

            public void suggestionSelected() {
                String name = DropDownExamplePage.this.cityText.getText();
                CountryInfo.City city = DropDownExamplePage.this.currentCountry.findCity(name);
                DropDownExamplePage.this.cityMap.visit(city);
            }
        });
    }

    private void createCityMap(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("City Map");
        group.setLayout((Layout)new FillLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Browser browser = new Browser((Composite)group, 0);
        this.cityMap = new CityMap(browser);
    }

    private static DataSource createCountriesDataSource() {
        DataSource countriesDataSource = new DataSource();
        countriesDataSource.setDataProvider((DataProvider)new DataProvider<CountryInfo.Country>(){

            public Iterable<CountryInfo.Country> getSuggestions() {
                return Arrays.asList(CountryInfo.getInstance().getCountries());
            }

            public String getValue(CountryInfo.Country country) {
                return country.name;
            }
        });
        return countriesDataSource;
    }

    private static DataSource createDataSource(CountryInfo.Country country) {
        DataSource dataSource = new DataSource();
        final CountryInfo.City[] cities = country.getCities();
        dataSource.setDataProvider((DataProvider)new DataProvider<CountryInfo.City>(){

            public Iterable<CountryInfo.City> getSuggestions() {
                return Arrays.asList(cities);
            }

            public String getValue(CountryInfo.City city) {
                return city.toString();
            }
        });
        return dataSource;
    }
}

