/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rap.clientscripting.Script;
import org.eclipse.rap.clientscripting.internal.ClientListenerBinding;
import org.eclipse.rap.clientscripting.internal.resources.ClientScriptingResources;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.remote.RemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFunction {
    private static final String REMOTE_TYPE = "rwt.scripting.Function";
    private final RemoteObject remoteObject;
    private final Collection<ClientListenerBinding> bindings = new ArrayList<ClientListenerBinding>();

    public ClientFunction(String scriptCode) {
        this();
        if (scriptCode == null) {
            throw new NullPointerException("Parameter is null: scriptCode");
        }
        this.remoteObject.set("scriptCode", scriptCode);
    }

    public ClientFunction(Script script) {
        this();
        if (script == null) {
            throw new NullPointerException("Parameter is null: script");
        }
        this.remoteObject.set("scriptId", script.getId());
    }

    private ClientFunction() {
        this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        ClientScriptingResources.ensure();
        this.remoteObject.set("name", "handleEvent");
    }

    protected String getRemoteId() {
        return this.remoteObject.getId();
    }

    Collection<ClientListenerBinding> getBindings() {
        return this.bindings;
    }

    protected ClientListenerBinding addTo(String targetId, String eventType) {
        if (this.findBinding(targetId, eventType) == null) {
            ClientListenerBinding binding = new ClientListenerBinding(this, targetId, eventType);
            this.bindings.add(binding);
            return binding;
        }
        return null;
    }

    protected void removeFrom(String targetId, String eventType) {
        ClientListenerBinding binding = this.findBinding(targetId, eventType);
        if (binding != null) {
            binding.dispose();
            this.bindings.remove(binding);
        }
    }

    protected ClientListenerBinding findBinding(String targetId, String eventType) {
        for (ClientListenerBinding binding : this.bindings) {
            if (!binding.getTargetId().equals(targetId) || !binding.getEventType().equals(eventType)) continue;
            return binding;
        }
        return null;
    }
}

