/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.rulers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public abstract class RulerProvider {
    public static final String PROPERTY_HORIZONTAL_RULER = "horizontal ruler";
    public static final String PROPERTY_RULER_VISIBILITY = "ruler$visibility";
    public static final String PROPERTY_VERTICAL_RULER = "vertical ruler";
    public static final int UNIT_CENTIMETERS = 1;
    public static final int UNIT_INCHES = 0;
    public static final int UNIT_PIXELS = 2;
    protected List listeners = new ArrayList();

    public void addRulerChangeListener(RulerChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void getAccGuideDescription(AccessibleEvent e, Object guide) {
        e.result = GEFMessages.get().Guide_Desc;
    }

    public void getAccGuideName(AccessibleEvent e, Object guide) {
        e.result = GEFMessages.get().Guide_Label;
    }

    public void getAccGuideValue(AccessibleControlEvent e, Object guide) {
        e.result = "" + this.getGuidePosition(guide);
    }

    public List getAttachedModelObjects(Object guide) {
        return Collections.EMPTY_LIST;
    }

    public List getAttachedEditParts(Object guide, GraphicalViewer viewer) {
        List attachedModelObjects = this.getAttachedModelObjects(guide);
        ArrayList attachedEditParts = new ArrayList(attachedModelObjects.size());
        Iterator i = attachedModelObjects.iterator();
        while (i.hasNext()) {
            Object editPart = viewer.getEditPartRegistry().get(i.next());
            if (editPart == null) continue;
            attachedEditParts.add(editPart);
        }
        return attachedEditParts;
    }

    public Command getCreateGuideCommand(int position) {
        return UnexecutableCommand.INSTANCE;
    }

    public Command getDeleteGuideCommand(Object guide) {
        return UnexecutableCommand.INSTANCE;
    }

    public Object getGuideAt(int position) {
        List guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            Object guide = guides.get(i);
            if (position == this.getGuidePosition(guide)) {
                return guide;
            }
            ++i;
        }
        return null;
    }

    public Command getMoveGuideCommand(Object guide, int positionDelta) {
        return UnexecutableCommand.INSTANCE;
    }

    public List getGuides() {
        return Collections.EMPTY_LIST;
    }

    public int[] getGuidePositions() {
        return new int[0];
    }

    public int getGuidePosition(Object guide) {
        return Integer.MIN_VALUE;
    }

    public Object getRuler() {
        return null;
    }

    public int getUnit() {
        return 0;
    }

    public void removeRulerChangeListener(RulerChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setUnit(int newUnit) {
    }
}

