/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.requests;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;

public class ChangeBoundsRequest
extends GroupRequest
implements DropRequest {
    private Point moveDelta = new Point();
    private Dimension resizeDelta = new Dimension();
    private int resizeDirection;
    private Point mouseLocation;
    private int flags = 0;
    private static final int CONSTRAINED_RESIZE = 1;
    private static final int CENTERED_RESIZE = 2;
    private static final int CONSTRAINED_MOVE = 4;
    private static final int SNAP_TO = 16;

    public ChangeBoundsRequest() {
    }

    public ChangeBoundsRequest(Object type) {
        this.setType(type);
    }

    public Point getLocation() {
        return this.mouseLocation;
    }

    public Point getMouseLocation() {
        return this.getLocation();
    }

    public Point getMoveDelta() {
        return this.moveDelta;
    }

    public int getResizeDirection() {
        return this.resizeDirection;
    }

    public Dimension getSizeDelta() {
        return this.resizeDelta;
    }

    public Rectangle getTransformedRectangle(Rectangle rect) {
        return rect.getCopy().translate(this.moveDelta).resize(this.resizeDelta);
    }

    public boolean isCenteredResize() {
        return (this.flags & 2) != 0;
    }

    public boolean isConstrainedMove() {
        return (this.flags & 4) != 0;
    }

    public boolean isConstrainedResize() {
        return (this.flags & 1) == 1;
    }

    public boolean isSnapToEnabled() {
        return (this.flags & 0x10) != 0;
    }

    public void setCenteredResize(boolean value) {
        this.flags = value ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public void setConstrainedMove(boolean value) {
        this.flags = value ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public void setConstrainedResize(boolean value) {
        this.flags = value ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public void setLocation(Point p) {
        this.mouseLocation = p;
    }

    public void setMouseLocation(Point p) {
        this.setLocation(p);
    }

    public void setMoveDelta(Point p) {
        this.moveDelta = p;
    }

    public void setResizeDirection(int dir) {
        this.resizeDirection = dir;
    }

    public void setSizeDelta(Dimension d) {
        this.resizeDelta = d;
    }

    public void setSnapToEnabled(boolean value) {
        this.flags = value ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }
}

