/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.ArrowButton;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DefaultRangeModel;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ScrollBarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.swt.graphics.Color;

public class ScrollBar
extends Figure
implements Orientable,
PropertyChangeListener {
    private static final int ORIENTATION_FLAG;
    protected static final int MAX_FLAG;
    private static final Color COLOR_TRACK;
    private RangeModel rangeModel = null;
    private IFigure thumb;
    private Clickable pageUp;
    private Clickable pageDown;
    private Clickable buttonUp;
    private Clickable buttonDown;
    protected ThumbDragger thumbDragger = new ThumbDragger();
    private boolean isHorizontal = false;
    private int pageIncrement = 50;
    private int stepIncrement = 10;
    protected final Transposer transposer = new Transposer();

    static {
        MAX_FLAG = ORIENTATION_FLAG = Figure.MAX_FLAG << 1;
        COLOR_TRACK = FigureUtilities.mixColors(ColorConstants.white(), ColorConstants.button());
    }

    public ScrollBar() {
        this.setRangeModel(new DefaultRangeModel());
        this.initialize();
    }

    protected Clickable createDefaultUpButton() {
        ArrowButton buttonUp = new ArrowButton();
        buttonUp.setBorder(new ButtonBorder(ButtonBorder.SCHEMES.BUTTON_SCROLLBAR()));
        return buttonUp;
    }

    protected Clickable createDefaultDownButton() {
        ArrowButton buttonDown = new ArrowButton();
        buttonDown.setBorder(new ButtonBorder(ButtonBorder.SCHEMES.BUTTON_SCROLLBAR()));
        return buttonDown;
    }

    protected Clickable createPageDown() {
        return this.createPageUp();
    }

    protected Clickable createPageUp() {
        final Clickable clickable = new Clickable();
        clickable.setOpaque(true);
        clickable.setBackgroundColor(COLOR_TRACK);
        clickable.setRequestFocusEnabled(false);
        clickable.setFocusTraversable(false);
        clickable.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent evt) {
                if (clickable.getModel().isArmed()) {
                    clickable.setBackgroundColor(ColorConstants.black());
                } else {
                    clickable.setBackgroundColor(COLOR_TRACK);
                }
            }
        });
        return clickable;
    }

    protected IFigure createDefaultThumb() {
        Panel thumb = new Panel();
        thumb.setMinimumSize(new Dimension(6, 6));
        thumb.setBackgroundColor(ColorConstants.button());
        thumb.setBorder(new SchemeBorder(SchemeBorder.SCHEMES.BUTTON_CONTRAST()));
        return thumb;
    }

    protected IFigure getButtonUp() {
        return this.buttonUp;
    }

    protected IFigure getButtonDown() {
        return this.buttonDown;
    }

    public int getExtent() {
        return this.getRangeModel().getExtent();
    }

    public int getMinimum() {
        return this.getRangeModel().getMinimum();
    }

    public int getMaximum() {
        return this.getRangeModel().getMaximum();
    }

    protected IFigure getPageDown() {
        return this.pageDown;
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    protected IFigure getPageUp() {
        return this.pageUp;
    }

    public RangeModel getRangeModel() {
        return this.rangeModel;
    }

    public int getStepIncrement() {
        return this.stepIncrement;
    }

    protected IFigure getThumb() {
        return this.thumb;
    }

    public int getValue() {
        return this.getRangeModel().getValue();
    }

    protected int getValueRange() {
        return this.getMaximum() - this.getExtent() - this.getMinimum();
    }

    protected void initialize() {
        this.setLayoutManager(new ScrollBarLayout(this.transposer));
        this.setUpClickable(this.createDefaultUpButton());
        this.setDownClickable(this.createDefaultDownButton());
        this.setPageUp(this.createPageUp());
        this.setPageDown(this.createPageDown());
        this.setThumb(this.createDefaultThumb());
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    private void pageDown() {
        this.setValue(this.getValue() + this.getPageIncrement());
    }

    private void pageUp() {
        this.setValue(this.getValue() - this.getPageIncrement());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof RangeModel) {
            this.setEnabled(this.getRangeModel().isEnabled());
            if ("value".equals(event.getPropertyName())) {
                this.firePropertyChange("value", event.getOldValue(), event.getNewValue());
                this.revalidate();
            }
            if ("minimum".equals(event.getPropertyName())) {
                this.firePropertyChange("value", event.getOldValue(), event.getNewValue());
                this.revalidate();
            }
            if ("maximum".equals(event.getPropertyName())) {
                this.firePropertyChange("value", event.getOldValue(), event.getNewValue());
                this.revalidate();
            }
            if ("extent".equals(event.getPropertyName())) {
                this.firePropertyChange("value", event.getOldValue(), event.getNewValue());
                this.revalidate();
            }
        }
    }

    public void revalidate() {
        this.invalidate();
        this.getUpdateManager().addInvalidFigure(this);
    }

    public void setDirection(int direction) {
    }

    public void setDownClickable(Clickable down) {
        if (this.buttonDown != null) {
            this.remove(this.buttonDown);
        }
        this.buttonDown = down;
        if (this.buttonDown != null) {
            if (this.buttonDown instanceof Orientable) {
                ((Orientable)((Object)this.buttonDown)).setDirection(this.isHorizontal() ? 16 : 4);
            }
            this.buttonDown.setFiringMethod(1);
            this.buttonDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ScrollBar.this.stepDown();
                }
            });
            this.add((IFigure)this.buttonDown, "down arrow");
        }
    }

    public void setUpClickable(Clickable up) {
        if (this.buttonUp != null) {
            this.remove(this.buttonUp);
        }
        this.buttonUp = up;
        if (up != null) {
            if (up instanceof Orientable) {
                ((Orientable)((Object)up)).setDirection(this.isHorizontal() ? 8 : 1);
            }
            this.buttonUp.setFiringMethod(1);
            this.buttonUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ScrollBar.this.stepUp();
                }
            });
            this.add((IFigure)this.buttonUp, "up arrow");
        }
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        super.setEnabled(value);
        this.setChildrenEnabled(value);
        if (this.getThumb() != null) {
            this.getThumb().setVisible(value);
            this.revalidate();
        }
    }

    public void setExtent(int ext) {
        if (this.getExtent() == ext) {
            return;
        }
        this.getRangeModel().setExtent(ext);
    }

    public final void setHorizontal(boolean value) {
        this.setOrientation(value ? 0 : 1);
    }

    public void setMaximum(int max) {
        if (this.getMaximum() == max) {
            return;
        }
        this.getRangeModel().setMaximum(max);
    }

    public void setMinimum(int min) {
        if (this.getMinimum() == min) {
            return;
        }
        this.getRangeModel().setMinimum(min);
    }

    public void setOrientation(int value) {
        if (value == 0 == this.isHorizontal()) {
            return;
        }
        this.isHorizontal = value == 0;
        this.transposer.setEnabled(this.isHorizontal);
        this.setChildrenOrientation(value);
        super.revalidate();
    }

    public void setPageIncrement(int increment) {
        this.pageIncrement = increment;
    }

    public void setPageDown(Clickable down) {
        if (this.pageDown != null) {
            this.remove(this.pageDown);
        }
        this.pageDown = down;
        if (this.pageDown != null) {
            this.pageDown.setFiringMethod(1);
            this.pageDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ScrollBar.this.pageDown();
                }
            });
            this.add((IFigure)down, "page_down");
        }
    }

    public void setPageUp(Clickable up) {
        if (this.pageUp != null) {
            this.remove(this.pageUp);
        }
        this.pageUp = up;
        if (this.pageUp != null) {
            this.pageUp.setFiringMethod(1);
            this.pageUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ScrollBar.this.pageUp();
                }
            });
            this.add((IFigure)this.pageUp, "page_up");
        }
    }

    public void setRangeModel(RangeModel rangeModel) {
        if (this.rangeModel != null) {
            this.rangeModel.removePropertyChangeListener(this);
        }
        this.rangeModel = rangeModel;
        rangeModel.addPropertyChangeListener(this);
    }

    public void setStepIncrement(int increment) {
        this.stepIncrement = increment;
    }

    public void setThumb(IFigure figure) {
        if (this.thumb != null) {
            this.thumb.removeMouseListener(this.thumbDragger);
            this.thumb.removeMouseMotionListener(this.thumbDragger);
            this.remove(this.thumb);
        }
        this.thumb = figure;
        if (this.thumb != null) {
            this.thumb.addMouseListener(this.thumbDragger);
            this.thumb.addMouseMotionListener(this.thumbDragger);
            this.add(this.thumb, "thumb");
        }
    }

    public void setValue(int v) {
        this.getRangeModel().setValue(v);
    }

    protected void stepDown() {
        this.setValue(this.getValue() + this.getStepIncrement());
    }

    protected void stepUp() {
        this.setValue(this.getValue() - this.getStepIncrement());
    }

    protected class ThumbDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        protected Point start;
        protected int dragRange;
        protected int revertValue;
        protected boolean armed;

        public void mousePressed(MouseEvent me) {
            this.armed = true;
            this.start = me.getLocation();
            Rectangle area = new Rectangle(ScrollBar.this.transposer.t(ScrollBar.this.getClientArea()));
            Dimension thumbSize = ScrollBar.this.transposer.t(ScrollBar.this.getThumb().getSize());
            if (ScrollBar.this.getButtonUp() != null) {
                area.height -= ScrollBar.this.transposer.t((Dimension)ScrollBar.this.getButtonUp().getSize()).height;
            }
            if (ScrollBar.this.getButtonDown() != null) {
                area.height -= ScrollBar.this.transposer.t((Dimension)ScrollBar.this.getButtonDown().getSize()).height;
            }
            Dimension sizeDifference = new Dimension(area.width, area.height - thumbSize.height);
            this.dragRange = sizeDifference.height;
            this.revertValue = ScrollBar.this.getValue();
            me.consume();
        }

        public void mouseDragged(MouseEvent me) {
            if (!this.armed) {
                return;
            }
            Dimension difference = ScrollBar.this.transposer.t(me.getLocation().getDifference(this.start));
            int change = ScrollBar.this.getValueRange() * difference.height / this.dragRange;
            ScrollBar.this.setValue(this.revertValue + change);
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (!this.armed) {
                return;
            }
            this.armed = false;
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }
}

