/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.rap.e4.E4ApplicationConfig;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class E4EntryPointFactory
implements EntryPointFactory {
    private static final String PLUGIN_ID = "org.eclipse.e4.ui.workbench.rap";
    private String productName;
    private E4ApplicationConfig config;

    public E4EntryPointFactory(E4ApplicationConfig config) {
        this.config = config;
    }

    public EntryPoint create() {
        return new EntryPoint(){

            public int createUI() {
                try {
                    E4EntryPointFactory.this.createWorkbench();
                }
                catch (Exception exception) {
                    E4EntryPointFactory.this.logProblem(exception);
                }
                return 0;
            }
        };
    }

    private int createWorkbench() {
        Shell shell;
        Display display = new Display();
        E4Application e4App = new E4Application();
        E4Workbench workbench = e4App.createE4Workbench(this.getApplicationContext(this.config), display);
        if (this.config.isDefaultPush()) {
            ServerPushSession session = new ServerPushSession();
            session.start();
        }
        if ((shell = display.getActiveShell()) == null) {
            shell = new Shell();
            shell.setLocation(0, 10000);
        }
        IEclipseContext workbenchContext = workbench.getContext();
        workbench.createAndRunUI((MApplicationElement)workbench.getApplication());
        if (e4App.lcManager != null) {
            ContextInjectionFactory.invoke((Object)e4App.lcManager, PreSave.class, (IEclipseContext)workbenchContext, null);
        }
        e4App.saveModel();
        workbench.close();
        if (workbench.isRestart()) {
            return IApplication.EXIT_RESTART;
        }
        return IApplication.EXIT_OK;
    }

    private IApplicationContext getApplicationContext(final E4ApplicationConfig config) {
        return new IApplicationContext(){

            public Bundle getBrandingBundle() {
                return null;
            }

            public void setResult(Object result, IApplication application) {
            }

            public String getBrandingProperty(String key) {
                if ("applicationXMI".equals(key)) {
                    return config.getXmiURI();
                }
                if ("lifeCycleURI".equals(key)) {
                    return config.getLifecycleURI();
                }
                if ("presentationURI".equals(key)) {
                    return config.getPresentationURI();
                }
                if ("clearPersistedState".equals(key)) {
                    return String.valueOf(config.isClearPersistedState());
                }
                if ("persistState".equals(key)) {
                    return String.valueOf(config.isPersistState());
                }
                return null;
            }

            public String getBrandingName() {
                return null;
            }

            public String getBrandingId() {
                return null;
            }

            public String getBrandingDescription() {
                return null;
            }

            public String getBrandingApplication() {
                return null;
            }

            public Map getArguments() {
                HashMap<String, String[]> rv = new HashMap<String, String[]>();
                rv.put("application.args", new String[0]);
                return rv;
            }

            public void applicationRunning() {
            }
        };
    }

    private void logProblem(Throwable problem) {
        System.err.println("Problem");
        problem.printStackTrace();
    }
}

