/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

class PaletteTreeProvider
implements ITreeContentProvider {
    private TreeViewer viewer;
    private PaletteRoot root;
    private PropertyChangeListener modelListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PaletteTreeProvider.this.handlePropertyChanged(evt);
        }
    };

    public PaletteTreeProvider(TreeViewer treeviewer) {
        this.viewer = treeviewer;
    }

    public void dispose() {
        this.traverseModel(this.root, false);
    }

    public Object[] getChildren(Object parentElement) {
        List children;
        if (parentElement instanceof PaletteContainer && !(children = ((PaletteContainer)parentElement).getChildren()).isEmpty()) {
            return children.toArray();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = this.getChildren(inputElement);
        if (elements == null) {
            elements = new Object[]{};
        }
        return elements;
    }

    public Object getParent(Object element) {
        return ((PaletteEntry)element).getParent();
    }

    protected void handlePropertyChanged(PropertyChangeEvent evt) {
        PaletteEntry entry = (PaletteEntry)evt.getSource();
        String property = evt.getPropertyName();
        if (property.equals("Name") || property.equals("Small Icon")) {
            this.viewer.update((Object)entry, null);
        } else if (property.equals("Visible")) {
            this.viewer.refresh((Object)entry);
        } else if (property.equals("Children Changed")) {
            this.viewer.refresh((Object)entry);
            List oldChildren = (List)evt.getOldValue();
            for (PaletteEntry child : oldChildren) {
                this.traverseModel(child, false);
            }
            this.traverseModel(entry, true);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.root != null) {
            this.traverseModel(this.root, false);
        }
        if (newInput != null) {
            this.root = (PaletteRoot)newInput;
            this.traverseModel(this.root, true);
        }
    }

    private void traverseModel(PaletteEntry entry, boolean isHook) {
        if (isHook) {
            entry.addPropertyChangeListener(this.modelListener);
        } else {
            entry.removePropertyChangeListener(this.modelListener);
        }
        if (this.hasChildren(entry)) {
            Object[] children = this.getChildren(entry);
            int i = 0;
            while (i < children.length) {
                this.traverseModel((PaletteEntry)children[i], isHook);
                ++i;
            }
        }
    }
}

