/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class GridColumn
extends Item {
    private static final int SORT_INDICATOR_WIDTH = 10;
    private static final int MARGIN_IMAGE = 3;
    private static final int DEFAULT_WIDTH = 10;
    private int width = 10;
    private int minimumWidth;
    private Grid parent;
    private GridColumnGroup group;
    private int sortStyle = 0;
    private boolean check;
    private boolean tableCheck;
    private boolean moveable;
    private boolean resizeable = true;
    private boolean checkable = true;
    private boolean detail = true;
    private boolean summary = true;
    private boolean visible = true;
    private int alignment = 16384;
    private Font headerFont;
    private String headerTooltip;
    private String footerText = "";
    private Image footerImage;
    private Font footerFont;
    private boolean packed;
    int imageCount;
    int textCount;

    public GridColumn(Grid parent, int style) {
        this(parent, style, -1);
    }

    public GridColumn(Grid parent, int style, int index) {
        super((Widget)parent, style, index);
        this.init(parent, style, index);
    }

    public GridColumn(GridColumnGroup parent, int style) {
        super((Widget)parent.getParent(), style, parent.getNewColumnIndex());
        this.init(parent.getParent(), style, parent.getNewColumnIndex());
        this.group = parent;
        this.group.newColumn(this);
    }

    public void dispose() {
        if (!this.parent.isDisposing() && !this.isDisposed()) {
            this.parent.removeColumn(this);
            if (this.group != null) {
                this.group.removeColumn(this);
            }
        }
        super.dispose();
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    public GridColumnGroup getColumnGroup() {
        this.checkWidget();
        return this.group;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(10, (Listener)typedListener);
        this.addListener(11, (Listener)typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(10, (SWTEventListener)listener);
        this.removeListener(11, (SWTEventListener)listener);
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.internalSetWidth(width);
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.checkWidget();
        this.minimumWidth = Math.max(0, minimumWidth);
        if (minimumWidth > this.width) {
            this.internalSetWidth(minimumWidth);
        }
    }

    public int getMinimumWidth() {
        this.checkWidget();
        return this.minimumWidth;
    }

    public void setText(String text) {
        super.setText(text);
        this.parent.layoutCache.invalidateHeaderHeight();
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.parent.layoutCache.invalidateHeaderHeight();
    }

    public void setSort(int style) {
        this.checkWidget();
        if (style == 128 || style == 1024 || style == 0) {
            if (style != 0) {
                int i = 0;
                while (i < this.parent.getColumnCount()) {
                    GridColumn column = this.parent.getColumn(i);
                    if (column != this) {
                        column.setSort(0);
                    }
                    ++i;
                }
            }
            this.sortStyle = style;
            this.parent.redraw();
        }
    }

    public int getSort() {
        this.checkWidget();
        return this.sortStyle;
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
        this.parent.redraw();
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public void setResizeable(boolean resizeable) {
        this.checkWidget();
        this.resizeable = resizeable;
    }

    public boolean getResizeable() {
        this.checkWidget();
        return this.resizeable;
    }

    public void setCheckable(boolean checkable) {
        this.checkWidget();
        this.checkable = checkable;
    }

    public boolean getCheckable() {
        this.checkWidget();
        return this.checkable;
    }

    public void setDetail(boolean detail) {
        this.checkWidget();
        this.detail = detail;
    }

    public boolean isDetail() {
        this.checkWidget();
        return this.detail;
    }

    public void setSummary(boolean summary) {
        this.checkWidget();
        this.summary = summary;
    }

    public boolean isSummary() {
        this.checkWidget();
        return this.summary;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        boolean before = this.isVisible();
        this.visible = visible;
        if (this.isVisible() != before) {
            if (visible) {
                this.notifyListeners(22, new Event());
            } else {
                this.notifyListeners(23, new Event());
            }
            GridColumn[] orderedColumns = this.parent.getColumnsInOrder();
            boolean fire = false;
            int i = 0;
            while (i < orderedColumns.length) {
                GridColumn column = orderedColumns[i];
                if (column == this) {
                    fire = true;
                } else if (fire && column.isVisible()) {
                    column.fireMoved();
                }
                ++i;
            }
            this.parent.redraw();
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    public boolean isVisible() {
        this.checkWidget();
        boolean result = this.visible;
        if (this.group != null && !this.group.isDisposed() && (this.group.getExpanded() && !this.isDetail() || !this.group.getExpanded() && !this.isSummary())) {
            result = false;
        }
        return result;
    }

    public boolean isCheck() {
        this.checkWidget();
        return this.check || this.tableCheck;
    }

    public boolean isTree() {
        this.checkWidget();
        return this.parent.isTreeColumn(this.parent.indexOf(this));
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if (alignment == 16384 || alignment == 0x1000000 || alignment == 131072) {
            this.alignment = alignment;
        }
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public void setHeaderFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent.layoutCache.invalidateHeaderHeight();
        this.headerFont = font;
    }

    public Font getHeaderFont() {
        this.checkWidget();
        return this.headerFont == null ? this.parent.getFont() : this.headerFont;
    }

    public void setHeaderTooltip(String tooltip) {
        this.checkWidget();
        this.headerTooltip = tooltip;
    }

    public String getHeaderTooltip() {
        this.checkWidget();
        return this.headerTooltip;
    }

    public void setFooterText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        this.footerText = text;
        this.parent.layoutCache.invalidateFooterHeight();
    }

    public String getFooterText() {
        this.checkWidget();
        return this.footerText;
    }

    public void setFooterImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        this.footerImage = image;
        this.parent.layoutCache.invalidateFooterHeight();
    }

    public Image getFooterImage() {
        this.checkWidget();
        return this.footerImage;
    }

    public void setFooterFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.footerFont = font;
        this.parent.layoutCache.invalidateFooterHeight();
    }

    public Font getFooterFont() {
        this.checkWidget();
        return this.footerFont == null ? this.parent.getFont() : this.footerFont;
    }

    public void pack() {
        this.checkWidget();
        int newWidth = Math.max(this.getPreferredWidth(), this.parent.getMaxContentWidth(this));
        this.setWidth(newWidth);
        this.packed = true;
        this.parent.redraw();
    }

    void repack() {
        if (this.packed) {
            this.pack();
        }
    }

    int getLeft() {
        int result = 0;
        int[] columnOrder = this.parent.getColumnOrder();
        boolean found = false;
        int i = 0;
        while (i < columnOrder.length && !found) {
            GridColumn currentColumn = this.parent.getColumn(columnOrder[i]);
            if (currentColumn == this) {
                found = true;
            } else if (currentColumn.isVisible()) {
                result += currentColumn.getWidth();
            }
            ++i;
        }
        return result;
    }

    private int getPreferredWidth() {
        int headerWidth = 0;
        String headerText = this.getText();
        Image headerImage = this.getImage();
        headerWidth = this.getContentWidth(this.getHeaderFont(), headerText, headerImage);
        if (this.sortStyle != 0) {
            headerWidth += 10;
            if (headerText.length() > 0 || headerImage != null) {
                headerWidth += 3;
            }
        }
        int footerWidth = 0;
        if (this.parent.getFooterVisible()) {
            footerWidth = this.getContentWidth(this.getFooterFont(), this.footerText, this.footerImage);
        }
        return Math.max(headerWidth, footerWidth);
    }

    private int getContentWidth(Font font, String text, Image image) {
        int contentWidth = 0;
        if (text.length() > 0) {
            contentWidth += TextSizeUtil.textExtent((Font)font, (String)text, (int)0).x;
        }
        if (image != null) {
            contentWidth += image.getBounds().width;
            if (text.length() > 0) {
                contentWidth += 3;
            }
        }
        return contentWidth += this.parent.getHeaderPadding().width;
    }

    private void internalSetWidth(int width) {
        int newWidth = Math.max(this.minimumWidth, width);
        if (this.width != newWidth) {
            this.width = newWidth;
            this.packed = false;
            this.processControlEvents();
            this.parent.setScrollValuesObsolete();
        }
    }

    protected boolean isTableCheck() {
        return this.tableCheck;
    }

    protected void setTableCheck(boolean tableCheck) {
        this.tableCheck = tableCheck;
    }

    private void init(Grid parent, int style, int index) {
        this.parent = parent;
        if ((style & 0x20000) == 131072) {
            this.alignment = 131072;
        }
        if ((style & 0x1000000) == 0x1000000) {
            this.alignment = 0x1000000;
        }
        if ((style & 0x20) == 32) {
            this.check = true;
        }
        parent.newColumn(this, index);
    }

    private void processControlEvents() {
        int[] columnOrder = this.parent.getColumnOrder();
        boolean found = false;
        int i = 0;
        while (i < columnOrder.length) {
            GridColumn currentColumn = this.parent.getColumn(columnOrder[i]);
            if (currentColumn == this) {
                found = true;
                this.fireResized();
            } else if (found) {
                currentColumn.fireMoved();
            }
            ++i;
        }
    }

    void fireResized() {
        Event event = new Event();
        event.display = this.getDisplay();
        event.item = this;
        event.widget = this.parent;
        this.notifyListeners(11, event);
    }

    void fireMoved() {
        Event event = new Event();
        event.display = this.getDisplay();
        event.item = this;
        event.widget = this.parent;
        this.notifyListeners(10, event);
    }
}

