/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import java.util.List;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeaturePointer;
import org.eclipse.e4.emf.internal.xpath.helper.JXPathEObjectInfo;
import org.eclipse.e4.emf.internal.xpath.helper.ValueUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidAccessException;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public class EObjectPropertyPointer
extends EStructuralFeaturePointer {
    private static final long serialVersionUID = -6008991447676468786L;
    private static final Object UNINITIALIZED = new Object();
    private String propertyName;
    private final JXPathEObjectInfo beanInfo;
    private Object baseValue = UNINITIALIZED;
    private Object value = UNINITIALIZED;
    private transient String[] names;
    private transient EStructuralFeature[] propertyDescriptors;
    private transient EStructuralFeature propertyDescriptor;

    public EObjectPropertyPointer(NodePointer parent, JXPathEObjectInfo beanInfo) {
        super(parent);
        this.beanInfo = beanInfo;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public int getPropertyCount() {
        if (this.beanInfo.isAtomic()) {
            return 0;
        }
        return this.getPropertyDescriptors().length;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.names == null) {
            EStructuralFeature[] pds = this.getPropertyDescriptors();
            this.names = new String[pds.length];
            int i = 0;
            while (i < this.names.length) {
                this.names[i] = pds[i].getName();
                ++i;
            }
        }
        return this.names;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(Integer.MIN_VALUE);
        this.propertyName = propertyName;
    }

    @Override
    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.propertyName = null;
            this.propertyDescriptor = null;
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
    }

    @Override
    public Object getBaseValue() {
        if (this.baseValue == UNINITIALIZED) {
            EStructuralFeature pd = this.getPropertyDescriptor();
            if (pd == null) {
                return null;
            }
            this.baseValue = ValueUtils.getValue(this.getBean(), pd);
        }
        return this.baseValue;
    }

    @Override
    public void setIndex(int index) {
        if (this.index == index) {
            return;
        }
        if (this.index != Integer.MIN_VALUE || index != 0 || this.isCollection()) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    @Override
    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            EStructuralFeature pd;
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.getBaseValue()) : ((pd = this.getPropertyDescriptor()) == null ? null : ValueUtils.getValue(this.getBean(), pd, this.index));
        }
        return this.value;
    }

    @Override
    protected boolean isActualProperty() {
        return this.getPropertyDescriptor() != null;
    }

    @Override
    public boolean isCollection() {
        EStructuralFeature pd = this.getPropertyDescriptor();
        if (pd == null) {
            return false;
        }
        if (pd.isMany()) {
            return true;
        }
        int hint = ValueUtils.getCollectionHint(pd.getEType().getInstanceClass());
        if (hint == -1) {
            return false;
        }
        if (hint == 1) {
            return true;
        }
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    @Override
    public int getLength() {
        EStructuralFeature pd = this.getPropertyDescriptor();
        if (pd == null) {
            return 1;
        }
        if (pd.isMany()) {
            return ((List)this.getBean().eGet(pd)).size();
        }
        return ValueUtils.getLength(this.getBaseValue());
    }

    @Override
    public void setValue(Object value) {
        EStructuralFeature pd = this.getPropertyDescriptor();
        if (pd == null) {
            throw new JXPathInvalidAccessException("Cannot set property: " + this.asPath() + " - no such property");
        }
        if (this.index == Integer.MIN_VALUE) {
            ValueUtils.setValue(this.getBean(), pd, value);
        } else {
            ValueUtils.setValue(this.getBean(), pd, this.index, value);
        }
        this.value = value;
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        if (this.getImmediateNode() == null) {
            super.createPath(context);
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
        return this;
    }

    @Override
    public void remove() {
        if (this.index == Integer.MIN_VALUE) {
            this.setValue(null);
        } else if (this.isCollection()) {
            Object o = this.getBaseValue();
            Object collection = ValueUtils.remove(this.getBaseValue(), this.index);
            if (collection != o) {
                ValueUtils.setValue(this.getBean(), this.getPropertyDescriptor(), collection);
            }
        } else if (this.index == 0) {
            this.index = Integer.MIN_VALUE;
            this.setValue(null);
        }
    }

    @Override
    public String getPropertyName() {
        EStructuralFeature pd;
        if (this.propertyName == null && (pd = this.getPropertyDescriptor()) != null) {
            this.propertyName = pd.getName();
        }
        return this.propertyName != null ? this.propertyName : "*";
    }

    private EStructuralFeature getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            int inx = this.getPropertyIndex();
            if (inx == Integer.MIN_VALUE) {
                this.propertyDescriptor = this.beanInfo.getPropertyDescriptor(this.propertyName);
            } else {
                EStructuralFeature[] propertyDescriptors = this.getPropertyDescriptors();
                this.propertyDescriptor = inx >= 0 && inx < propertyDescriptors.length ? propertyDescriptors[inx] : null;
            }
        }
        return this.propertyDescriptor;
    }

    protected synchronized EStructuralFeature[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        }
        return this.propertyDescriptors;
    }
}

