/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public class Decorator
extends Widget {
    private static final String KEY_DECORATORS = Widget.class.getName() + "#decorators";
    private static final Decorator[] EMPTY_DECORATORS = new Decorator[0];
    private Widget decoratedWidget;
    private DisposeListener disposeListener;

    public static Decorator[] getDecorators(Widget widget) {
        Decorator[] result = EMPTY_DECORATORS;
        List<Decorator> decorationsList = Decorator.getDecoratorsList(widget);
        if (decorationsList != null) {
            result = decorationsList.toArray(new Decorator[decorationsList.size()]);
        }
        return result;
    }

    public Decorator(Widget widget, int style) {
        super(widget, style);
        this.decoratedWidget = widget;
        this.registerDisposeListeners();
        this.bindDecoration();
    }

    protected final Widget getDecoratedWidget() {
        return this.decoratedWidget;
    }

    private void registerDisposeListeners() {
        this.disposeListener = new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent event) {
                Decorator.this.release();
            }
        };
        this.addDisposeListener(this.disposeListener);
        this.decoratedWidget.addDisposeListener(this.disposeListener);
    }

    private void release() {
        if (this.decoratedWidget != null && !this.decoratedWidget.isDisposed()) {
            this.removeDisposeListener(this.disposeListener);
            this.decoratedWidget.removeDisposeListener(this.disposeListener);
            this.disposeListener = null;
            this.unbindDecoration();
            this.decoratedWidget = null;
            this.dispose();
        }
    }

    private void bindDecoration() {
        List<Decorator> decorations = Decorator.getDecoratorsList(this.decoratedWidget);
        if (decorations == null) {
            decorations = new ArrayList<Decorator>();
        }
        decorations.add(this);
        this.setDecoratorsList(decorations);
    }

    private void unbindDecoration() {
        List<Decorator> decorations = Decorator.getDecoratorsList(this.decoratedWidget);
        if (decorations != null) {
            decorations.remove(this);
            if (decorations.size() == 0) {
                decorations = null;
            }
            this.setDecoratorsList(decorations);
        }
    }

    private void setDecoratorsList(List<Decorator> decorations) {
        this.decoratedWidget.setData(KEY_DECORATORS, decorations);
    }

    private static List<Decorator> getDecoratorsList(Widget widget) {
        return (List)widget.getData(KEY_DECORATORS);
    }
}

