/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLResourceFactory
implements ResourceFactory {
    static Consumer<InputStream> ON_SWEEP_LISTENER;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean useCaches = true;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    @Override
    public Resource newResource(URI uri) {
        try {
            return new URLResource(uri, this.connectTimeout, this.readTimeout, this.useCaches);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Bad URI: " + String.valueOf(uri), e);
        }
    }

    private static class URLResource
    extends Resource {
        private static final Logger LOG = LoggerFactory.getLogger(URLResource.class);
        private static final Cleaner CLEANER = Cleaner.create();
        private final AutoLock lock = new AutoLock();
        private final URI uri;
        private final URL url;
        private final int connectTimeout;
        private final int readTimeout;
        private final boolean useCaches;
        private URLConnection connection;
        private InputStreamReference inputStreamReference = null;

        public URLResource(URI uri, int connectTimeout, int readTimeout, boolean useCaches) throws MalformedURLException {
            this.uri = uri;
            this.url = uri.toURL();
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.useCaches = useCaches;
        }

        protected boolean checkConnection() throws IOException {
            try (AutoLock l = this.lock.lock();){
                if (this.connection == null) {
                    try {
                        this.connection = this.url.openConnection();
                        this.connection.setConnectTimeout(this.connectTimeout);
                        this.connection.setReadTimeout(this.readTimeout);
                        this.connection.setUseCaches(this.useCaches);
                    }
                    catch (IOException e) {
                        LOG.trace("IGNORED", (Throwable)e);
                    }
                }
                boolean bl = this.connection != null;
                return bl;
            }
        }

        @Override
        public Path getPath() {
            return null;
        }

        @Override
        public boolean isContainedIn(Resource container) {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return this.exists() && this.uri.getSchemeSpecificPart().endsWith("/");
        }

        @Override
        public boolean isReadable() {
            return this.exists();
        }

        @Override
        public URI getURI() {
            return URIUtil.correctURI(this.uri);
        }

        @Override
        public String getName() {
            return this.uri.toASCIIString();
        }

        @Override
        public String getFileName() {
            return FileID.getFileName(this.uri);
        }

        @Override
        public Resource resolve(String subUriPath) {
            if (URIUtil.isNotNormalWithinSelf(subUriPath)) {
                throw new IllegalArgumentException(subUriPath);
            }
            if ("/".equals(subUriPath)) {
                return this;
            }
            URI newURI = URIUtil.addPath(this.uri, subUriPath);
            try {
                return new URLResource(newURI, this.connectTimeout, this.readTimeout, this.useCaches);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean exists() {
            try (AutoLock l = this.lock.lock();){
                if (!this.checkConnection()) return false;
                if (this.inputStreamReference == null || this.inputStreamReference.get() == null) {
                    this.inputStreamReference = new InputStreamReference(this.connection.getInputStream());
                    CLEANER.register(this, this.inputStreamReference);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOG.trace("IGNORED", (Throwable)e);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newInputStream() throws IOException {
            try (AutoLock l = this.lock.lock();){
                block15: {
                    InputStream inputStream;
                    if (!this.checkConnection()) {
                        throw new IOException("Invalid resource");
                    }
                    try {
                        if (this.inputStreamReference == null) break block15;
                        InputStream stream = this.inputStreamReference.getAndSet(null);
                        this.inputStreamReference = null;
                        if (stream == null) break block15;
                        inputStream = stream;
                        this.connection = null;
                    }
                    catch (Throwable throwable) {
                        this.connection = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Connection nulled");
                        }
                        throw throwable;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Connection nulled");
                    }
                    return inputStream;
                }
                InputStream inputStream = this.connection.getInputStream();
                this.connection = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection nulled");
                }
                return inputStream;
            }
        }

        @Override
        public Instant lastModified() {
            AutoLock l = this.lock.lock();
            try {
                if (!this.checkConnection()) {
                    throw new IOException("Invalid resource");
                }
                Instant instant = Instant.ofEpochMilli(this.connection.getLastModified());
                if (l != null) {
                    l.close();
                }
                return instant;
            }
            catch (Throwable throwable) {
                try {
                    if (l != null) {
                        try {
                            l.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Instant.EPOCH;
                }
            }
        }

        @Override
        public long length() {
            AutoLock l = this.lock.lock();
            try {
                if (!this.checkConnection()) {
                    throw new IOException("Invalid resource");
                }
                long l2 = this.connection.getContentLengthLong();
                if (l != null) {
                    l.close();
                }
                return l2;
            }
            catch (Throwable throwable) {
                try {
                    if (l != null) {
                        try {
                            l.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return -1L;
                }
            }
        }

        @Override
        public ReadableByteChannel newReadableByteChannel() throws IOException {
            return Channels.newChannel(this.newInputStream());
        }

        @Override
        public URI getRealURI() {
            return this.getURI();
        }

        @Override
        public String toString() {
            return "(URL) " + this.uri.toASCIIString();
        }

        private static class InputStreamReference
        extends AtomicReference<InputStream>
        implements Runnable {
            public InputStreamReference(InputStream initialValue) {
                super(initialValue);
            }

            @Override
            public void run() {
                InputStream in = this.getAndSet(null);
                if (in != null) {
                    IO.close(in);
                }
                if (ON_SWEEP_LISTENER != null) {
                    ON_SWEEP_LISTENER.accept(in);
                }
            }
        }
    }
}

