/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal.engine;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;

public class ThemeManagerHelper {
    private static ThemeManager themeManager;

    public static void resetThemeManager() {
        if (ThemeManagerHelper.isThemeManagerAvailable()) {
            ThemeManagerHelper.doThemeManagerReset();
        }
    }

    public static void resetThemeManagerIfNeeded() {
        if (ThemeManagerHelper.isThemeManagerResetNeeded()) {
            ThemeManagerHelper.doThemeManagerReset();
        }
    }

    public static ThemeManager ensureThemeManager() {
        if (themeManager == null) {
            themeManager = new TestThemeManager();
        }
        return themeManager;
    }

    private static void doThemeManagerReset() {
        ((TestThemeManager)themeManager).resetInstanceInTestCases();
    }

    private static boolean isThemeManagerResetNeeded() {
        List<String> registeredThemeIds;
        boolean result = ThemeManagerHelper.isThemeManagerAvailable();
        if (result && (registeredThemeIds = Arrays.asList(themeManager.getRegisteredThemeIds())).size() == 2) {
            result = !registeredThemeIds.contains("org.eclipse.rap.rwt.theme.Fallback") || !registeredThemeIds.contains("org.eclipse.rap.rwt.theme.Default");
        }
        return result;
    }

    private static boolean isThemeManagerAvailable() {
        return themeManager != null;
    }

    public static class TestThemeManager
    extends ThemeManager {
        boolean initialized;
        boolean activated;
        boolean deactivated;

        public void initialize() {
            if (!this.initialized) {
                this.registerTheme(new Theme("org.eclipse.rap.rwt.theme.Default", "RAP Default Theme", null));
                this.initialized = true;
            }
        }

        public void activate() {
            if (!this.activated) {
                super.activate();
                this.activated = true;
            }
            this.deactivated = false;
        }

        public void deactivate() {
            this.deactivated = true;
        }

        public String[] getRegisteredThemeIds() {
            String[] result = new String[]{};
            if (!this.deactivated) {
                result = super.getRegisteredThemeIds();
            }
            return result;
        }

        public void resetInstanceInTestCases() {
            this.initialized = false;
            this.activated = false;
            super.deactivate();
        }
    }
}

