/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class HTTP {
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_JAVASCRIPT = "text/javascript";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_MULTIPART = "multipart/form-data";
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String HEADER_ACCEPT = "Accept";

    public static String getParameter(HttpServletRequest request, String name) {
        if (CONTENT_TYPE_MULTIPART.equals(HTTP.getMediaType(request.getContentType()))) {
            return HTTP.getQueryStringParameter(request, name);
        }
        return request.getParameter(name);
    }

    public static String getQueryStringParameter(HttpServletRequest request, String name) {
        Map<String, List<String>> parameterMap;
        List<String> parameter;
        String queryString = request.getQueryString();
        if (queryString != null && (parameter = (parameterMap = HTTP.getParameterMap(queryString)).get(name)) != null) {
            return parameter.get(0);
        }
        return null;
    }

    public static Map<String, List<String>> getParameterMap(String queryString) {
        LinkedHashMap<String, List<String>> parametersMap = new LinkedHashMap<String, List<String>>();
        try {
            String[] pairs;
            String[] stringArray = pairs = queryString.split("&");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String key;
                String pair = stringArray[n2];
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), CHARSET_UTF_8) : pair;
                if (!parametersMap.containsKey(key)) {
                    parametersMap.put(key, new LinkedList());
                }
                String value = null;
                if (idx > 0 && pair.length() > idx + 1) {
                    value = URLDecoder.decode(pair.substring(idx + 1), CHARSET_UTF_8);
                }
                ((List)parametersMap.get(key)).add(value);
                ++n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return parametersMap;
    }

    public static String getMediaType(String contentType) {
        String result = null;
        if (contentType != null) {
            int semicolon = contentType.indexOf(59);
            result = semicolon > -1 ? contentType.substring(0, semicolon) : contentType;
            result = result.trim().toLowerCase(Locale.ENGLISH);
        }
        return result;
    }

    private HTTP() {
    }
}

