/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.JXPathContextFactoryConfigurationError;

public abstract class JXPathContextFactory {
    public static final String FACTORY_NAME_PROPERTY = "org.apache.commons.jxpath.JXPathContextFactory";
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.commons.jxpath.ri.JXPathContextFactoryReferenceImpl";
    private static String factoryImplName = null;
    private static boolean debug = false;

    static {
        try {
            debug = System.getProperty("jxpath.debug") != null;
        }
        catch (SecurityException securityException) {}
    }

    protected JXPathContextFactory() {
    }

    public static JXPathContextFactory newInstance() {
        JXPathContextFactory factoryImpl;
        if (factoryImplName == null) {
            factoryImplName = JXPathContextFactory.findFactory(FACTORY_NAME_PROPERTY, DEFAULT_FACTORY_CLASS);
        }
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (JXPathContextFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new JXPathContextFactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new JXPathContextFactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new JXPathContextFactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract JXPathContext newContext(JXPathContext var1, Object var2);

    private static String findFactory(String property, String defaultFactory) {
        block28: {
            block27: {
                try {
                    String systemProp = System.getProperty(property);
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("JXPath: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException securityException) {}
                try {
                    String factory;
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jxpath.properties";
                    File f = new File(configFile);
                    if (!f.exists()) break block27;
                    Properties props = new Properties();
                    FileInputStream fis = new FileInputStream(f);
                    try {
                        props.load(fis);
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if ((factory = props.getProperty(property)) != null) {
                        if (debug) {
                            System.err.println("JXPath: found java.home property " + factory);
                        }
                        return factory;
                    }
                }
                catch (IOException ex) {
                    if (!debug) break block27;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + property;
            try {
                ClassLoader cl = JXPathContextFactory.class.getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is == null) break block28;
                if (debug) {
                    System.err.println("JXPath: found  " + serviceId);
                }
                BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                String factory = null;
                try {
                    factory = rd.readLine();
                }
                catch (Throwable throwable) {
                    try {
                        rd.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
                if (factory != null && !"".equals(factory)) {
                    if (debug) {
                        System.err.println("JXPath: loaded from services: " + factory);
                    }
                    return factory;
                }
            }
            catch (Exception ex) {
                if (!debug) break block28;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }
}

