/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.command.adapter.CustomCommandInterpreter;
import org.eclipse.equinox.console.commands.CommandsTracker;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HelpCommand {
    private BundleContext context;
    private Set<CommandProvider> legacyCommandProviders;
    private ServiceTracker<CommandProvider, Set<CommandProvider>> commandProvidersTracker;
    private ServiceTracker<CommandsTracker, CommandsTracker> commandsTrackerTracker;
    private static final String COMMANDS = ".commands";

    public HelpCommand(BundleContext context) {
        this.context = context;
        this.legacyCommandProviders = new HashSet<CommandProvider>();
        this.commandProvidersTracker = new ServiceTracker(context, CommandProvider.class, (ServiceTrackerCustomizer)new CommandProviderCustomizer(context));
        this.commandProvidersTracker.open();
        this.commandsTrackerTracker = new ServiceTracker(context, CommandsTracker.class, null);
        this.commandsTrackerTracker.open();
    }

    public void startService() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
        ((Dictionary)props).put("osgi.command.scope", "equinox");
        ((Dictionary)props).put("osgi.command.function", new String[]{"help"});
        this.context.registerService(HelpCommand.class.getName(), (Object)this, props);
    }

    public void help(CommandSession session, String ... args) throws Exception {
        String command = null;
        String scope = null;
        if (args.length > 0) {
            if (args[0].equals("-scope")) {
                if (args.length < 2) {
                    System.out.println("Specify scope");
                    return;
                }
                scope = args[1];
            } else {
                command = args[0];
            }
        }
        if (command != null) {
            this.printLegacyCommandHelp(session, command);
            this.printGogoCommandHelp(session, command);
            return;
        }
        if (scope == null || "equinox".equals(scope)) {
            this.printAllLegacyCommandsHelp();
        }
        this.printAllGogoCommandsHelp(session, scope);
    }

    private void printGogoCommandHelp(CommandSession session, String command) throws Exception {
        try {
            session.execute((CharSequence)("felix:help " + command));
        }
        catch (IllegalArgumentException e) {
            this.handleCommandNotFound();
        }
    }

    private void printAllLegacyCommandsHelp() {
        for (CommandProvider commandProvider : this.legacyCommandProviders) {
            System.out.println(commandProvider.getHelp());
        }
    }

    private void printAllGogoCommandsHelp(CommandSession session, String scope) throws Exception {
        CommandsTracker commandsTracker = (CommandsTracker)this.commandsTrackerTracker.getService();
        Set commandNames = null;
        if (commandsTracker != null) {
            commandNames = commandsTracker.getCommands();
        }
        if (commandNames == null || commandNames.isEmpty()) {
            commandNames = (Set)session.get(COMMANDS);
        }
        try {
            for (String commandName : commandNames) {
                if (scope != null && !commandName.startsWith(String.valueOf(scope) + ":")) continue;
                System.out.println(session.execute((CharSequence)("felix:help " + commandName)));
            }
        }
        catch (IllegalArgumentException e) {
            this.handleCommandNotFound();
        }
    }

    private void printLegacyCommandHelp(CommandSession session, String command) {
        block2: for (CommandProvider provider : this.legacyCommandProviders) {
            Method[] methods;
            Method[] methodArray = methods = provider.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Object retval = null;
                if (method.getName().equals("_" + command)) {
                    try {
                        Method helpMethod = provider.getClass().getMethod("_help", CommandInterpreter.class);
                        ArrayList<Object> argsList = new ArrayList<Object>();
                        argsList.add(command);
                        retval = helpMethod.invoke((Object)provider, new CustomCommandInterpreter(session, argsList));
                    }
                    catch (Exception e) {
                        System.out.println(provider.getHelp());
                        continue block2;
                    }
                    if (retval == null || !(retval instanceof String)) continue block2;
                    System.out.println(retval);
                    continue block2;
                }
                ++n2;
            }
        }
    }

    private boolean checkStarted(String symbolicName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = this.context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(symbolicName) && bundle.getState() == 32) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void handleCommandNotFound() {
        if (this.checkStarted("org.apache.felix.gogo.command")) {
            System.out.println("Cannot find felix:help command");
        } else {
            System.out.println("Cannot find felix:help command; bundle org.apache.felix.gogo.command is not started");
        }
    }

    public class CommandProviderCustomizer
    implements ServiceTrackerCustomizer<CommandProvider, Set<CommandProvider>> {
        private BundleContext context;

        public CommandProviderCustomizer(BundleContext context) {
            this.context = context;
        }

        public Set<CommandProvider> addingService(ServiceReference<CommandProvider> reference) {
            if (reference.getProperty("osgi.command.function") != null) {
                return null;
            }
            CommandProvider command = (CommandProvider)this.context.getService(reference);
            HelpCommand.this.legacyCommandProviders.add(command);
            this.context.ungetService(reference);
            return HelpCommand.this.legacyCommandProviders;
        }

        public void modifiedService(ServiceReference<CommandProvider> reference, Set<CommandProvider> service) {
        }

        public void removedService(ServiceReference<CommandProvider> reference, Set<CommandProvider> providers) {
            CommandProvider provider = (CommandProvider)this.context.getService(reference);
            providers.remove(provider);
        }
    }
}

