/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.io.Serializable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.internal.util.SerializableListenerList;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class OpenStrategy
implements Serializable {
    public static final int DOUBLE_CLICK = 0;
    public static final int SINGLE_CLICK = 1;
    public static final int SELECT_ON_HOVER = 2;
    public static final int ARROW_KEYS_OPEN = 4;
    public static final int NO_TIMER = 1;
    public static final int FILE_EXPLORER = 5;
    public static final int ACTIVE_DESKTOP = 3;
    private static int CURRENT_METHOD = 0;
    private Listener eventHandler;
    private ListenerList openEventListeners = new SerializableListenerList();
    private ListenerList selectionEventListeners = new SerializableListenerList();
    private ListenerList postSelectionEventListeners = new SerializableListenerList();

    public OpenStrategy(Control control) {
        this.initializeHandler(control.getDisplay());
        this.addListener(control);
    }

    public void addOpenListener(IOpenEventListener listener) {
        this.openEventListeners.add((Object)listener);
    }

    public void removeOpenListener(IOpenEventListener listener) {
        this.openEventListeners.remove((Object)listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionEventListeners.add((Object)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionEventListeners.remove((Object)listener);
    }

    public void addPostSelectionListener(SelectionListener listener) {
        this.postSelectionEventListeners.add((Object)listener);
    }

    public void removePostSelectionListener(SelectionListener listener) {
        this.postSelectionEventListeners.remove((Object)listener);
    }

    public static int getOpenMethod() {
        return CURRENT_METHOD;
    }

    public static void setOpenMethod(int method) {
        if (method == 0) {
            CURRENT_METHOD = method;
            return;
        }
        if ((method & 1) == 0) {
            throw new IllegalArgumentException("Invalid open mode");
        }
        if ((method & 7) == 0) {
            throw new IllegalArgumentException("Invalid open mode");
        }
        CURRENT_METHOD = method;
    }

    public static boolean activateOnOpen() {
        return OpenStrategy.getOpenMethod() == 0;
    }

    private void addListener(Control c) {
        c.addListener(13, this.eventHandler);
        c.addListener(14, this.eventHandler);
        c.addListener(18, this.eventHandler);
        c.addListener(17, this.eventHandler);
    }

    private void fireSelectionEvent(SelectionEvent e) {
        if (e.item != null && e.item.isDisposed()) {
            return;
        }
        Object[] l = this.selectionEventListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((SelectionListener)l[i]).widgetSelected(e);
            ++i;
        }
    }

    private void fireDefaultSelectionEvent(SelectionEvent e) {
        Object[] l = this.selectionEventListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((SelectionListener)l[i]).widgetDefaultSelected(e);
            ++i;
        }
    }

    private void firePostSelectionEvent(SelectionEvent e) {
        if (e.item != null && e.item.isDisposed()) {
            return;
        }
        Object[] l = this.postSelectionEventListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((SelectionListener)l[i]).widgetSelected(e);
            ++i;
        }
    }

    private void fireOpenEvent(SelectionEvent e) {
        if (e.item != null && e.item.isDisposed()) {
            return;
        }
        Object[] l = this.openEventListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IOpenEventListener)l[i]).handleOpen(e);
            ++i;
        }
    }

    private void initializeHandler(final Display display) {
        this.eventHandler = new Listener(){
            Event mouseUpEvent = null;
            boolean enterKeyDown = false;
            boolean arrowKeyDown = false;
            final int[] count = new int[1];

            public void handleEvent(final Event e) {
                if (e.type == 14) {
                    SelectionEvent event = new SelectionEvent(e);
                    OpenStrategy.this.fireDefaultSelectionEvent(event);
                    if (CURRENT_METHOD == 0) {
                        OpenStrategy.this.fireOpenEvent(event);
                    } else if (this.enterKeyDown) {
                        OpenStrategy.this.fireOpenEvent(event);
                        this.enterKeyDown = false;
                    }
                    return;
                }
                switch (e.type) {
                    case 13: {
                        SelectionEvent event = new SelectionEvent(e);
                        OpenStrategy.this.fireSelectionEvent(event);
                        if (this.mouseUpEvent != null) {
                            this.mouseSelectItem(event);
                        }
                        this.count[0] = this.count[0] + 1;
                        final int id = this.count[0];
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (arrowKeyDown) {
                                    if (id == count[0]) {
                                        OpenStrategy.this.firePostSelectionEvent(new SelectionEvent(e));
                                        if ((CURRENT_METHOD & 4) != 0) {
                                            OpenStrategy.this.fireOpenEvent(new SelectionEvent(e));
                                        }
                                    }
                                } else {
                                    OpenStrategy.this.firePostSelectionEvent(new SelectionEvent(e));
                                }
                            }
                        });
                    }
                }
            }

            void mouseSelectItem(SelectionEvent e) {
                if ((CURRENT_METHOD & 1) != 0) {
                    OpenStrategy.this.fireOpenEvent(e);
                }
                this.mouseUpEvent = null;
            }
        };
    }
}

