/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.interactiondesign;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rap.ui.interactiondesign.ConfigurationAction;
import org.eclipse.rap.ui.interactiondesign.internal.ConfigurableStackProxy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class ConfigurableStack
extends StackPresentation {
    private static final String CONFIG_ACTION_NAME = "actionClass";
    private static IStackPresentationSite siteDummy = new IStackPresentationSite(){

        @Override
        public void addSystemActions(IMenuManager menuManager) {
        }

        @Override
        public void close(IPresentablePart[] toClose) {
        }

        @Override
        public void dragStart(IPresentablePart beingDragged, Point initialPosition, boolean keyboard) {
        }

        @Override
        public void dragStart(Point initialPosition, boolean keyboard) {
        }

        @Override
        public void flushLayout() {
        }

        @Override
        public IPresentablePart[] getPartList() {
            return null;
        }

        @Override
        public String getProperty(String id) {
            return null;
        }

        @Override
        public IPresentablePart getSelectedPart() {
            return null;
        }

        @Override
        public int getState() {
            return 0;
        }

        @Override
        public boolean isCloseable(IPresentablePart toClose) {
            return false;
        }

        @Override
        public boolean isPartMoveable(IPresentablePart toMove) {
            return false;
        }

        @Override
        public boolean isStackMoveable() {
            return false;
        }

        @Override
        public void selectPart(IPresentablePart toSelect) {
        }

        @Override
        public void setState(int newState) {
        }

        @Override
        public boolean supportsState(int state) {
            return false;
        }
    };
    public static final String STACK_PRESENTATION_EXT_ID = "org.eclipse.rap.ui.stackPresentations";
    private ConfigurationAction configAction;
    private ImageDescriptor menuIcon;
    private Composite parent;
    private ConfigurableStackProxy proxy;
    private IStackPresentationSite site;
    private String stackPresentationId;
    private List managersWhoHasListeners;

    public static final String getLayoutPartId(IStackPresentationSite site) {
        String result = null;
        if (site != null && site instanceof DefaultStackPresentationSite) {
            DefaultStackPresentationSite defaultSite = (DefaultStackPresentationSite)site;
            result = defaultSite.getProperty("id");
        }
        return result;
    }

    public static String getSavedStackId(IStackPresentationSite site) {
        String layoutPartId = null;
        String result = "";
        layoutPartId = ConfigurableStack.getLayoutPartId(site);
        if (layoutPartId != null) {
            ScopedPreferenceStore prefStore = (ScopedPreferenceStore)PrefUtil.getAPIPreferenceStore();
            String stackPresentationId = "stackPresentationId";
            String stackPresentationKey = String.valueOf(stackPresentationId) + "/" + layoutPartId;
            result = prefStore.getString(stackPresentationKey);
        }
        return result;
    }

    public ConfigurableStack() {
        super(siteDummy);
    }

    public Control createPartToolBar() {
        Control result = null;
        IToolBarManager manager = this.getPartToolBarManager();
        ConfigurationAction action = this.getConfigAction();
        IStackPresentationSite site = this.getSite();
        int actionCount = 0;
        if (action != null && manager != null) {
            this.addPropertyChangeListenerToToolBar(manager);
            IContributionItem[] items = manager.getItems();
            String paneId = this.getPaneId(site);
            if (manager instanceof IToolBarManager2) {
                result = ((IToolBarManager2)manager).getControl2();
            }
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                boolean isVisible = action.isViewActionVisibile(paneId, item.getId());
                if (!item.isVisible() && isVisible || item.isVisible() && !isVisible) {
                    item.setVisible(isVisible);
                }
                if (isVisible) {
                    ++actionCount;
                }
                ++i;
            }
            if (manager != null && result != null) {
                manager.update(true);
            }
            if (actionCount <= 0) {
                result = null;
            }
            if (result != null) {
                result.pack();
                result.setVisible(true);
            }
        }
        return result;
    }

    private void addPropertyChangeListenerToToolBar(final IToolBarManager manager) {
        if (manager instanceof IToolBarManager2 && !this.hasListener(manager)) {
            final IToolBarManager2 manager2 = (IToolBarManager2)manager;
            final IPropertyChangeListener listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("PROP_LAYOUT") && ConfigurableStack.this.configAction != null) {
                        ConfigurableStack.this.configAction.fireToolBarChange();
                    }
                }
            };
            manager2.addPropertyChangeListener(listener);
            final Control toolBar = manager2.getControl2();
            if (toolBar != null) {
                toolBar.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        toolBar.removeDisposeListener((DisposeListener)this);
                        manager2.removePropertyChangeListener(listener);
                        if (ConfigurableStack.this.managersWhoHasListeners != null) {
                            ConfigurableStack.this.managersWhoHasListeners.remove(manager);
                        }
                    }
                });
            }
        }
    }

    private boolean hasListener(IToolBarManager manager) {
        boolean result = false;
        if (this.managersWhoHasListeners == null) {
            this.managersWhoHasListeners = new ArrayList();
        }
        if (this.managersWhoHasListeners.contains(manager)) {
            result = true;
        } else {
            this.managersWhoHasListeners.add(manager);
        }
        return result;
    }

    public IPartMenu createViewMenu() {
        IPartMenu result = null;
        if (this.isPartMenuVisisble()) {
            result = new IPartMenu(){

                @Override
                public void showMenu(Point location) {
                    IPresentablePart selectedPart = ConfigurableStack.this.site.getSelectedPart();
                    if (selectedPart instanceof PresentablePart) {
                        PresentablePart part = (PresentablePart)selectedPart;
                        part.getPane().showViewMenu(location);
                    }
                }
            };
        }
        return result;
    }

    public ConfigurationAction getConfigAction() {
        String stackId;
        IExtensionRegistry registry;
        IExtensionPoint point;
        ConfigurationAction result = null;
        if (this.configAction == null && this.stackPresentationId != null && !this.stackPresentationId.equals("") && (point = (registry = Platform.getExtensionRegistry()).getExtensionPoint(stackId = STACK_PRESENTATION_EXT_ID)) != null) {
            String defaultValue;
            IConfigurationElement[] elements = point.getConfigurationElements();
            String actionClass = defaultValue = "";
            boolean breakValue = true;
            IConfigurationElement element = null;
            ImageDescriptor imageDesc = null;
            int i = 0;
            while (breakValue && i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (id.equals(this.stackPresentationId) && (actionClass = elements[i].getAttribute(CONFIG_ACTION_NAME)) != null && !actionClass.equals(defaultValue)) {
                    breakValue = false;
                    element = elements[i];
                    String actionImage = element.getAttribute("actionIcon");
                    String menuImage = element.getAttribute("menuIcon");
                    String contributerId = element.getContributor().getName();
                    if (actionImage != null) {
                        imageDesc = AbstractUIPlugin.imageDescriptorFromPlugin(contributerId, actionImage);
                    }
                    if (menuImage != null) {
                        this.menuIcon = AbstractUIPlugin.imageDescriptorFromPlugin(contributerId, menuImage);
                    }
                }
                ++i;
            }
            String defaultStore = defaultValue;
            if (actionClass != null && !actionClass.equals(defaultStore) && element != null) {
                try {
                    Object obj = element.createExecutableExtension(CONFIG_ACTION_NAME);
                    if (obj instanceof ConfigurationAction) {
                        this.configAction = (ConfigurationAction)((Object)obj);
                        this.configAction.init(this.getSite(), this);
                        if (imageDesc != null) {
                            this.configAction.setImageDescriptor(imageDesc);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        result = this.configAction;
        return result;
    }

    protected ImageDescriptor getMenuIcon() {
        return this.menuIcon;
    }

    public final String getPaneId(IStackPresentationSite site) {
        String result = "";
        IPresentablePart selectedPart = site.getSelectedPart();
        if (selectedPart instanceof PresentablePart) {
            PresentablePart part = (PresentablePart)selectedPart;
            result = part.getPane().getID();
        }
        return result;
    }

    private String getSecondaryPaneId(IStackPresentationSite site) {
        PresentablePart part;
        PartPane pane;
        String result = null;
        IPresentablePart selectedPart = site.getSelectedPart();
        if (selectedPart instanceof PresentablePart && (pane = (part = (PresentablePart)selectedPart).getPane()) instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)pane;
            result = viewPane.getViewReference().getSecondaryId();
        }
        return result;
    }

    public Composite getParent() {
        return this.parent;
    }

    public IToolBarManager getPartToolBarManager() {
        IToolBarManager result = null;
        IStackPresentationSite site = this.getSite();
        String paneId = this.getPaneId(site);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            String secId = this.getSecondaryPaneId(site);
            IViewPart viewPart = null;
            if (secId != null) {
                IViewReference ref = activePage.findViewReference(paneId, secId);
                if (ref != null) {
                    viewPart = (ViewPart)ref.getPart(false);
                }
            } else {
                viewPart = activePage.findView(paneId);
            }
            IActionBars bars = null;
            if (viewPart != null) {
                IViewSite viewSite = (IViewSite)viewPart.getSite();
                bars = viewSite.getActionBars();
                result = bars.getToolBarManager();
            }
        }
        return result;
    }

    public boolean getShowTitle() {
        return this.proxy.getShowTitle();
    }

    @Override
    public IStackPresentationSite getSite() {
        return this.site;
    }

    public String getStackPresentationId() {
        return this.stackPresentationId;
    }

    protected String getType() {
        return this.proxy.getType();
    }

    public abstract void init();

    public void init(IStackPresentationSite site, String stackId, Composite parent, ConfigurableStackProxy proxy) {
        this.site = site;
        this.stackPresentationId = stackId;
        this.parent = parent;
        this.proxy = proxy;
        this.init();
    }

    private boolean isPartMenuVisisble() {
        boolean result = false;
        if (this.configAction != null) {
            result = this.configAction.isPartMenuVisible();
        }
        return result;
    }

    public void setCurrentStackPresentation(String newStackId) {
        if (this.proxy != null) {
            this.proxy.setCurrentStackPresentation(newStackId);
        }
    }
}

