/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FormLayoutExample
implements IExamplePage {
    private Composite parent;
    private Composite layoutArea;
    private boolean propPrefSize;

    public void createControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createLayoutArea();
        this.createControlButtons(parent);
    }

    private void createLayoutArea() {
        if (this.layoutArea == null) {
            this.layoutArea = new Composite(this.parent, 0);
            this.layoutArea.setLayout((Layout)ExampleUtil.createFillLayout((boolean)false));
            this.layoutArea.setLayoutData((Object)ExampleUtil.createFillData());
        }
        Control[] children = this.layoutArea.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.createLayoutComp(this.layoutArea);
        this.layoutArea.layout();
    }

    protected void createLayoutComp(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        Composite layoutComp = new Composite(composite, 2048);
        if (!this.propPrefSize) {
            layoutComp.setLayoutData((Object)ExampleUtil.createFillData());
        }
        FormLayout layout = new FormLayout();
        layoutComp.setLayout((Layout)layout);
        Label label = new Label(layoutComp, 0);
        label.setText("Label");
        Text text = new Text(layoutComp, 2058);
        text.setText("Text");
        FormData textData = new FormData();
        textData.left = new FormAttachment((Control)label, 0);
        textData.top = new FormAttachment((Control)label, 0);
        text.setLayoutData((Object)textData);
        Button button = new Button(layoutComp, 8);
        button.setText("Button");
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        button.setLayoutData((Object)buttonData);
    }

    protected void createControlButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)false, (boolean)true));
        final Button preferredSizeButton = new Button(composite, 32);
        preferredSizeButton.setText("Shrink containers to their preferred size");
        preferredSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormLayoutExample.this.propPrefSize = preferredSizeButton.getSelection();
                FormLayoutExample.this.createLayoutArea();
            }
        });
    }
}

