/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleRevisions;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.container.NamespaceList;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public final class ModuleRevision
implements BundleRevision {
    private final String symbolicName;
    private final Version version;
    private final int types;
    private final NamespaceList<ModuleCapability> capabilities;
    private final NamespaceList<ModuleRequirement> requirements;
    private final ModuleRevisions revisions;
    private final Object revisionInfo;
    private volatile Boolean lazyActivationPolicy = null;

    ModuleRevision(String symbolicName, Version version, int types, NamespaceList.Builder<ModuleRevisionBuilder.GenericInfo> capabilityInfos, NamespaceList.Builder<ModuleRevisionBuilder.GenericInfo> requirementInfos, ModuleRevisions revisions, Object revisionInfo) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.types = types;
        this.capabilities = this.createCapabilities(capabilityInfos);
        this.requirements = this.createRequirements(requirementInfos);
        this.revisions = revisions;
        this.revisionInfo = revisionInfo;
    }

    private NamespaceList<ModuleCapability> createCapabilities(NamespaceList.Builder<ModuleRevisionBuilder.GenericInfo> capabilityInfos) {
        return capabilityInfos.transformIntoCopy(new Function<ModuleRevisionBuilder.GenericInfo, ModuleCapability>(){

            @Override
            public ModuleCapability apply(ModuleRevisionBuilder.GenericInfo i) {
                Map<String, String> directives = i.mutable ? this.copyUnmodifiableMap(i.directives) : i.directives;
                Map<String, Object> attributes = i.mutable ? this.copyUnmodifiableMap(i.attributes) : i.attributes;
                return new ModuleCapability(i.namespace, directives, attributes, ModuleRevision.this);
            }

            private <K, V> Map<K, V> copyUnmodifiableMap(Map<K, V> map) {
                int size = map.size();
                if (size == 0) {
                    return Collections.emptyMap();
                }
                if (size == 1) {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
                return Collections.unmodifiableMap(new HashMap<K, V>(map));
            }
        }, NamespaceList.CAPABILITY).build();
    }

    private NamespaceList<ModuleRequirement> createRequirements(NamespaceList.Builder<ModuleRevisionBuilder.GenericInfo> infos) {
        return infos.transformIntoCopy(new Function<ModuleRevisionBuilder.GenericInfo, ModuleRequirement>(){

            @Override
            public ModuleRequirement apply(ModuleRevisionBuilder.GenericInfo i) {
                return new ModuleRequirement(i.namespace, i.directives, i.attributes, ModuleRevision.this);
            }
        }, NamespaceList.REQUIREMENT).build();
    }

    @Override
    public Bundle getBundle() {
        return this.revisions.getBundle();
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        return InternalUtils.asList(this.getModuleCapabilities(namespace));
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        return InternalUtils.asList(this.getModuleRequirements(namespace));
    }

    public List<ModuleCapability> getModuleCapabilities(String namespace) {
        return this.capabilities.getList(namespace);
    }

    public List<ModuleRequirement> getModuleRequirements(String namespace) {
        return this.requirements.getList(namespace);
    }

    @Override
    public int getTypes() {
        return this.types;
    }

    @Override
    public ModuleWiring getWiring() {
        return this.revisions.getContainer().getWiring(this);
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return InternalUtils.asList(this.getDeclaredCapabilities(namespace));
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return InternalUtils.asList(this.getDeclaredRequirements(namespace));
    }

    public ModuleRevisions getRevisions() {
        return this.revisions;
    }

    public Object getRevisionInfo() {
        return this.revisionInfo;
    }

    public boolean hasLazyActivatePolicy() {
        Boolean currentPolicy = this.lazyActivationPolicy;
        if (currentPolicy != null) {
            return currentPolicy;
        }
        boolean lazyPolicy = false;
        List<Capability> data = this.getCapabilities("equinox.module.data");
        if (!data.isEmpty()) {
            Capability moduleData = data.get(0);
            lazyPolicy = "lazy".equals(moduleData.getAttributes().get("activation.policy"));
        }
        this.lazyActivationPolicy = lazyPolicy;
        return lazyPolicy;
    }

    boolean isCurrent() {
        return !this.revisions.isUninstalled() && this.equals(this.revisions.getCurrentRevision());
    }

    public String toString() {
        List<ModuleCapability> identities = this.getModuleCapabilities("osgi.identity");
        if (identities.isEmpty()) {
            return super.toString();
        }
        return identities.get(0).toString();
    }

    static <V> String toString(Map<String, V> map, boolean directives) {
        return ModuleRevision.toString(map, directives, false);
    }

    static <V> String toString(Map<String, V> map, boolean directives, boolean stringsOnly) {
        if (map.size() == 0) {
            return "";
        }
        String assignment = directives ? ":=" : "=";
        Set<Map.Entry<String, V>> set = map.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, V> entry : set) {
            sb.append("; ");
            String key = entry.getKey();
            V value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) continue;
                Object component = list.get(0);
                String className = component.getClass().getName();
                String type = className.substring(className.lastIndexOf(46) + 1);
                sb.append(key).append(':').append("List<").append(type).append(">").append(assignment).append('\"');
                for (Object object : list) {
                    sb.append(object).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append('\"');
                continue;
            }
            String type = "";
            if (!(value instanceof String) && !stringsOnly) {
                String className = value.getClass().getName();
                type = ":" + className.substring(className.lastIndexOf(46) + 1);
            }
            sb.append(key).append(type).append(assignment).append('\"').append(value).append('\"');
        }
        return sb.toString();
    }

    NamespaceList<ModuleCapability> getCapabilities() {
        return this.capabilities;
    }

    NamespaceList<ModuleRequirement> getRequirements() {
        return this.requirements;
    }
}

