/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.internal.preferences.legacy.InitLegacyPreferences;
import org.eclipse.core.internal.preferences.legacy.ProductPreferencesService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.log.LogListener;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private static final String[] ARCH_LIST = new String[]{"aarch64", "x86", "x86_64"};
    public static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public static boolean DEBUG = false;
    public static boolean DEBUG_PLUGIN_PREFERENCES = false;
    private boolean splashEnded = false;
    private volatile boolean initialized;
    private static final String KEYRING = "-keyring";
    private String keyringFile;
    private final ConcurrentMap<Bundle, Log> logs = new ConcurrentHashMap<Bundle, Log>(5);
    private static final String[] OS_LIST = new String[]{"linux", "macosx", "win32"};
    private String password = "";
    private static final String PASSWORD = "-password";
    public static final String PROP_APPLICATION = "eclipse.application";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    private static final String PROP_REQUIRES_EXPLICIT_INIT = "osgi.dataAreaRequiresExplicitInit";
    public static final String PROP_PRODUCT = "eclipse.product";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_ACTIVATE_PLUGINS = "eclipse.activateRuntimePlugins";
    private static final InternalPlatform singleton = new InternalPlatform();
    private static final String[] WS_LIST = new String[]{"cocoa", "gtk", "win32", "wpf"};
    private IPath cachedInstanceLocation;
    private ServiceTracker<Location, Location> configurationLocation = null;
    private BundleContext context;
    private FrameworkWiring fwkWiring;
    private final Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> groupProviders = new HashMap<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>>(3);
    private ServiceTracker<Location, Location> installLocation = null;
    private ServiceTracker<Location, Location> instanceLocation = null;
    private ServiceTracker<Location, Location> userLocation = null;
    private Plugin runtimeInstance;
    private ServiceRegistration<ILegacyPreferences> legacyPreferencesService = null;
    private ServiceRegistration<IProductPreferencesService> customPreferencesService = null;
    private ServiceTracker<EnvironmentInfo, EnvironmentInfo> environmentTracker = null;
    private ServiceTracker<FrameworkLog, FrameworkLog> logTracker = null;
    private ServiceTracker<PlatformAdmin, PlatformAdmin> platformTracker = null;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    private ServiceTracker<IContentTypeManager, IContentTypeManager> contentTracker = null;
    private ServiceTracker<IPreferencesService, IPreferencesService> preferencesTracker = null;
    private ServiceTracker<IBundleGroupProvider, IBundleGroupProvider> groupProviderTracker = null;
    private ServiceTracker<ExtendedLogReaderService, ExtendedLogReaderService> logReaderTracker = null;
    private ServiceTracker<ExtendedLogService, ExtendedLogService> extendedLogTracker = null;
    private IProduct product;
    static final Comparator<Bundle> DESCENDING_BUNDLE_VERION = Comparator.comparing(Bundle::getVersion).reversed();

    public static InternalPlatform getDefault() {
        return singleton;
    }

    private InternalPlatform() {
    }

    public void addLogListener(ILogListener listener) {
        this.assertInitialized();
        RuntimeLog.addLogListener((ILogListener)listener);
    }

    private void assertInitialized() {
        if (!this.initialized) {
            Assert.isTrue((boolean)false, (String)Messages.meta_appNotInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSplash() {
        InternalPlatform internalPlatform = this;
        synchronized (internalPlatform) {
            if (this.splashEnded) {
                return;
            }
            this.splashEnded = true;
        }
        String filter = "(eclipse.application.type=main.thread)";
        ServiceCaller.callOnce(InternalPlatform.class, IApplicationContext.class, (String)"(eclipse.application.type=main.thread)", IApplicationContext::applicationRunning);
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        return AdapterManager.getDefault();
    }

    public String[] getApplicationArgs() {
        return CommandLineArgs.getApplicationArgs();
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        Bundle source = FrameworkUtil.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public IBundleGroupProvider[] getBundleGroupProviders() {
        return (IBundleGroupProvider[])this.groupProviderTracker.getServices((Object[])new IBundleGroupProvider[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleGroupProvider(IBundleGroupProvider provider) {
        ServiceRegistration registration = this.getBundleContext().registerService(IBundleGroupProvider.class, (Object)provider, null);
        Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> map = this.groupProviders;
        synchronized (map) {
            this.groupProviders.put(provider, (ServiceRegistration<IBundleGroupProvider>)registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundleGroupProvider(IBundleGroupProvider provider) {
        ServiceRegistration<IBundleGroupProvider> registration;
        Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> map = this.groupProviders;
        synchronized (map) {
            registration = this.groupProviders.remove(provider);
        }
        if (registration == null) {
            return;
        }
        registration.unregister();
    }

    public Bundle getBundle(String symbolicName) {
        Stream<Bundle> bundles = this.getBundles0(symbolicName, null);
        return bundles.findFirst().orElse(null);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        Stream<Bundle> result = this.getBundles0(symbolicName, versionRange);
        Bundle[] results = (Bundle[])result.toArray(Bundle[]::new);
        return results.length > 0 ? results : null;
    }

    private Stream<Bundle> getBundles0(String symbolicName, String versionRange) {
        if (!this.isRunning()) {
            return Stream.empty();
        }
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = this.context.getBundle("System Bundle").getSymbolicName();
        }
        Map<String, String> directives = Map.of("filter", this.getRequirementFilter(symbolicName, versionRange));
        Collection matchingBundleCapabilities = this.fwkWiring.findProviders(ModuleContainer.createRequirement((String)"osgi.identity", directives, Collections.emptyMap()));
        return matchingBundleCapabilities.stream().map(c -> c.getRevision().getBundle()).filter(bundle -> (bundle.getState() & 3) == 0).sorted(DESCENDING_BUNDLE_VERION);
    }

    private String getRequirementFilter(String symbolicName, String versionRange) {
        String identity = "(osgi.identity=" + symbolicName + ")";
        if (versionRange == null) {
            return identity;
        }
        String version = new VersionRange(versionRange).toFilterString("version");
        return "(&" + identity + version + ")";
    }

    public String[] getCommandLineArgs() {
        return CommandLineArgs.getAllArgs();
    }

    public Location getConfigurationLocation() {
        this.assertInitialized();
        return (Location)this.configurationLocation.getService();
    }

    public IContentTypeManager getContentTypeManager() {
        return this.contentTracker == null ? null : (IContentTypeManager)this.contentTracker.getService();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        return this.environmentTracker == null ? null : (EnvironmentInfo)this.environmentTracker.getService();
    }

    public FrameworkLog getFrameworkLog() {
        return this.logTracker == null ? null : (FrameworkLog)this.logTracker.getService();
    }

    public Bundle[] getFragments(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return null;
        }
        List hostWires = wiring.getProvidedWires("osgi.wiring.host");
        if (hostWires == null) {
            return null;
        }
        Bundle[] result = (Bundle[])hostWires.stream().map(wire -> wire.getRequirer().getBundle()).filter(Objects::nonNull).toArray(Bundle[]::new);
        return result.length > 0 ? result : null;
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return null;
        }
        List hostWires = wiring.getRequiredWires("osgi.wiring.host");
        if (hostWires == null) {
            return null;
        }
        Bundle[] result = (Bundle[])hostWires.stream().map(wire -> wire.getProvider().getBundle()).filter(Objects::nonNull).toArray(Bundle[]::new);
        return result.length > 0 ? result : null;
    }

    public Location getInstallLocation() {
        this.assertInitialized();
        return (Location)this.installLocation.getService();
    }

    public URL getInstallURL() {
        Location location = this.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        return (Location)this.instanceLocation.getService();
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            boolean explicitInitRequired;
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            if (!location.isSet() && (explicitInitRequired = Boolean.parseBoolean(this.getBundleContext().getProperty(PROP_REQUIRES_EXPLICIT_INIT)))) {
                throw new IllegalStateException(CommonMessages.meta_instanceDataUnspecified);
            }
            URL url = location.getURL();
            if (url == null) {
                throw new IllegalStateException("Instance location is not (yet) set");
            }
            File file = new File(url.getFile());
            this.cachedInstanceLocation = IPath.fromOSString((String)file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        if (this.isRunning()) {
            return this.logs.computeIfAbsent(bundle, b -> {
                ExtendedLogService logService = (ExtendedLogService)this.extendedLogTracker.getService();
                Logger logger = logService != null ? logService.getLogger(b, "org.eclipse.equinox.logger") : null;
                Log log = new Log((Bundle)b, logger);
                ExtendedLogReaderService logReader = (ExtendedLogReaderService)this.logReaderTracker.getService();
                if (logReader != null) {
                    logReader.addLogListener((LogListener)log, (LogFilter)log);
                }
                return log;
            });
        }
        return new Log(bundle, null);
    }

    public String getNL() {
        return this.getBundleContext().getProperty(PROP_NL);
    }

    public String getNLExtensions() {
        Object nlExtensions = PlatformActivator.getContext().getProperty("osgi.nl.extensions");
        if (nlExtensions == null) {
            return "";
        }
        if (!((String)nlExtensions).startsWith("@")) {
            nlExtensions = "@" + (String)nlExtensions;
        }
        return nlExtensions;
    }

    public String getOption(String option) {
        DebugOptions options = this.getDebugOptions();
        if (options != null) {
            return options.getOption(option);
        }
        return null;
    }

    public String getOS() {
        return this.getBundleContext().getProperty(PROP_OS);
    }

    public String getOSArch() {
        return this.getBundleContext().getProperty(PROP_ARCH);
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.platformTracker == null ? null : (PlatformAdmin)this.platformTracker.getService();
    }

    public IPreferencesService getPreferencesService() {
        return this.preferencesTracker == null ? null : (IPreferencesService)this.preferencesTracker.getService();
    }

    public IProduct getProduct() {
        IBranding branding;
        if (this.product != null) {
            return this.product;
        }
        EclipseAppContainer container = Activator.getContainer();
        IBranding iBranding = branding = container == null ? null : container.getBranding();
        if (branding == null) {
            return null;
        }
        Object brandingProduct = branding.getProduct();
        if (!(brandingProduct instanceof IProduct)) {
            brandingProduct = new Product(branding);
        }
        this.product = (IProduct)brandingProduct;
        return this.product;
    }

    public IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    public ResourceBundle getResourceBundle(Bundle bundle) {
        return ResourceTranslator.getResourceBundle((Bundle)bundle);
    }

    public String getResourceString(Bundle bundle, String value) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)value);
    }

    public String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)value, (ResourceBundle)resourceBundle);
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public IPath getStateLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertInitialized();
        IPath result = MetaDataKeeper.getMetaArea().getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public long getStateTimeStamp() {
        return Arrays.stream(this.getBundleContext().getBundles()).map(bundle -> (Module)bundle.adapt(Module.class)).filter(Objects::nonNull).mapToLong(Module::getLastModified).sum();
    }

    public Location getUserLocation() {
        this.assertInitialized();
        return (Location)this.userLocation.getService();
    }

    public String getWS() {
        return this.getBundleContext().getProperty(PROP_WS);
    }

    private void initializeAuthorizationHandler() {
        try {
            AuthorizationHandler.setKeyringFile(this.keyringFile);
            AuthorizationHandler.setPassword(this.password);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption("org.eclipse.core.runtime/debug", false);
        if (DEBUG) {
            DEBUG_PLUGIN_PREFERENCES = this.getBooleanOption("org.eclipse.core.runtime/preferences/plugin", false);
        }
    }

    public boolean isFragment(Bundle bundle) {
        BundleRevisions bundleRevisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        List revisions = bundleRevisions.getRevisions();
        if (revisions.isEmpty()) {
            return false;
        }
        return (((BundleRevision)revisions.get(0)).getTypes() & 1) != 0;
    }

    public boolean isRunning() {
        try {
            return this.initialized && this.context != null && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public String[] knownOSValues() {
        return OS_LIST;
    }

    public String[] knownWSValues() {
        return WS_LIST;
    }

    private void processCommandLine(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(KEYRING)) {
                    this.keyringFile = arg;
                }
                if (args[i - 1].equalsIgnoreCase(PASSWORD)) {
                    this.password = arg;
                }
            }
            ++i;
        }
    }

    public void removeLogListener(ILogListener listener) {
        this.assertInitialized();
        RuntimeLog.removeLogListener((ILogListener)listener);
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public void start(BundleContext runtimeContext) {
        this.context = runtimeContext;
        this.fwkWiring = (FrameworkWiring)runtimeContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        this.openOSGiTrackers();
        this.splashEnded = false;
        this.processCommandLine(this.getEnvironmentInfoService().getNonFrameworkArgs());
        this.initializeDebugFlags();
        this.initialized = true;
        this.initializeAuthorizationHandler();
        this.startServices();
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        this.stopServices();
        this.initialized = false;
        this.closeOSGITrackers();
        this.context = null;
    }

    private void openOSGiTrackers() {
        this.instanceLocation = this.createOpenTracker(Location.INSTANCE_FILTER);
        this.userLocation = this.createOpenTracker(Location.USER_FILTER);
        this.configurationLocation = this.createOpenTracker(Location.CONFIGURATION_FILTER);
        this.installLocation = this.createOpenTracker(Location.INSTALL_FILTER);
        this.logTracker = this.createOpenTracker(FrameworkLog.class);
        this.platformTracker = this.createOpenTracker(PlatformAdmin.class);
        this.contentTracker = this.createOpenTracker(IContentTypeManager.class);
        this.preferencesTracker = this.createOpenTracker(IPreferencesService.class);
        this.groupProviderTracker = this.createOpenTracker("(objectClass=" + IBundleGroupProvider.class.getName() + ")");
        this.logReaderTracker = this.createOpenTracker(ExtendedLogReaderService.class);
        this.extendedLogTracker = this.createOpenTracker(ExtendedLogService.class);
        this.environmentTracker = this.createOpenTracker(EnvironmentInfo.class);
        this.debugTracker = this.createOpenTracker(DebugOptions.class);
    }

    private <T> ServiceTracker<T, T> createOpenTracker(String filterStr) {
        try {
            Filter filter = FrameworkUtil.createFilter((String)filterStr);
            ServiceTracker tracker = new ServiceTracker(this.context, filter, null);
            tracker.open();
            return tracker;
        }
        catch (InvalidSyntaxException e) {
            throw new AssertionError((Object)"Invalid service tracker filter");
        }
    }

    private <T> ServiceTracker<T, T> createOpenTracker(Class<T> service) {
        ServiceTracker tracker = new ServiceTracker(this.context, service, null);
        tracker.open();
        return tracker;
    }

    private void startServices() {
        this.customPreferencesService = this.context.registerService(IProductPreferencesService.class, (Object)new ProductPreferencesService(), new Hashtable());
        this.legacyPreferencesService = this.context.registerService(ILegacyPreferences.class, (Object)new InitLegacyPreferences(), new Hashtable());
    }

    private void stopServices() {
        if (this.legacyPreferencesService != null) {
            this.legacyPreferencesService.unregister();
            this.legacyPreferencesService = null;
        }
        if (this.customPreferencesService != null) {
            this.customPreferencesService.unregister();
            this.customPreferencesService = null;
        }
    }

    private DebugOptions getDebugOptions() {
        return this.debugTracker == null ? null : (DebugOptions)this.debugTracker.getService();
    }

    private void closeOSGITrackers() {
        ExtendedLogReaderService logReader = (ExtendedLogReaderService)this.logReaderTracker.getService();
        if (logReader != null) {
            this.logs.forEach((b, log) -> logReader.removeLogListener((LogListener)log));
        }
        this.logs.clear();
        InternalPlatform.closeTracker(this.preferencesTracker);
        InternalPlatform.closeTracker(this.contentTracker);
        InternalPlatform.closeTracker(this.debugTracker);
        InternalPlatform.closeTracker(this.platformTracker);
        InternalPlatform.closeTracker(this.logTracker);
        InternalPlatform.closeTracker(this.groupProviderTracker);
        InternalPlatform.closeTracker(this.environmentTracker);
        InternalPlatform.closeTracker(this.logReaderTracker);
        InternalPlatform.closeTracker(this.extendedLogTracker);
        InternalPlatform.closeTracker(this.installLocation);
        InternalPlatform.closeTracker(this.userLocation);
        InternalPlatform.closeTracker(this.configurationLocation);
        InternalPlatform.closeTracker(this.instanceLocation);
    }

    private static void closeTracker(ServiceTracker<?, ?> tracker) {
        if (tracker != null) {
            tracker.close();
        }
    }

    public static void message(String message) {
        System.out.println(String.format("%s - [%s] %s", new Date(), Thread.currentThread().getName(), message));
    }

    public static void start(Bundle bundle) throws BundleException {
        int originalState = bundle.getState();
        if ((originalState & 0x20) != 0) {
            return;
        }
        try {
            bundle.start(1);
        }
        catch (BundleException e) {
            if ((originalState & 8) != 0 && (bundle.getState() & 8) != 0) {
                return;
            }
            throw e;
        }
    }
}

