/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;

public final class WidgetGraphicsAdapter
implements IWidgetGraphicsAdapter,
SerializableCompatibility {
    private int roundedBorderWidth;
    private Color roundedBorderColor;
    private Rectangle roundedBorderRadius;
    private Color[] backgroundGradientColors;
    private int[] backgroundGradientPercents;
    private boolean backgroundGradientVertical;

    @Override
    public Color[] getBackgroundGradientColors() {
        Color[] result = null;
        if (this.backgroundGradientColors != null) {
            result = (Color[])this.backgroundGradientColors.clone();
        }
        return result;
    }

    @Override
    public int[] getBackgroundGradientPercents() {
        int[] result = null;
        if (this.backgroundGradientPercents != null) {
            result = (int[])this.backgroundGradientPercents.clone();
        }
        return result;
    }

    @Override
    public boolean isBackgroundGradientVertical() {
        return this.backgroundGradientVertical;
    }

    @Override
    public void setBackgroundGradient(Color[] gradientColors, int[] percents, boolean vertical) {
        if (gradientColors != null && percents != null) {
            if (gradientColors.length != percents.length) {
                SWT.error(5);
            }
            int i = 0;
            while (i < gradientColors.length) {
                if (gradientColors[i] == null) {
                    SWT.error(5);
                }
                ++i;
            }
        }
        this.backgroundGradientColors = null;
        if (gradientColors != null) {
            this.backgroundGradientColors = (Color[])gradientColors.clone();
        }
        this.backgroundGradientPercents = null;
        if (percents != null) {
            this.backgroundGradientPercents = (int[])percents.clone();
        }
        this.backgroundGradientVertical = vertical;
    }

    @Override
    public int getRoundedBorderWidth() {
        return this.roundedBorderWidth;
    }

    @Override
    public Color getRoundedBorderColor() {
        return this.roundedBorderColor;
    }

    @Override
    public Rectangle getRoundedBorderRadius() {
        Rectangle result = this.roundedBorderRadius != null ? new Rectangle(this.roundedBorderRadius.x, this.roundedBorderRadius.y, this.roundedBorderRadius.width, this.roundedBorderRadius.height) : new Rectangle(0, 0, 0, 0);
        return result;
    }

    @Override
    public void setRoundedBorder(int width, Color color, int topLeftRadius, int topRightRadius, int bottomRightRadius, int bottomLeftRadius) {
        this.roundedBorderWidth = width;
        this.roundedBorderColor = color;
        this.roundedBorderRadius = new Rectangle(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius);
    }
}

