/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

public class DelayedObservableValue<T>
extends AbstractObservableValue<T>
implements IStaleListener,
IValueChangeListener<T> {
    private final int delay;
    private IObservableValue<T> observable;
    private boolean dirty = true;
    private T cachedValue = null;
    private boolean updating = false;
    private ValueUpdater updater = null;

    public DelayedObservableValue(int delayMillis, IObservableValue<T> observable) {
        super(observable.getRealm());
        this.delay = delayMillis;
        this.observable = observable;
        observable.addValueChangeListener(this);
        observable.addStaleListener(this);
        this.cachedValue = this.doGetValue();
    }

    @Override
    public void handleValueChange(ValueChangeEvent<? extends T> event) {
        if (!this.updating) {
            this.makeDirty();
        }
    }

    @Override
    public void handleStale(StaleEvent staleEvent) {
        if (!this.updating) {
            this.fireStale();
        }
    }

    private T internalGetValue() {
        ObservableTracker.setIgnore(true);
        try {
            T t = this.observable.getValue();
            return t;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    protected T doGetValue() {
        if (this.dirty) {
            this.cachedValue = this.internalGetValue();
            this.dirty = false;
            if (this.updater != null && !this.updater.running) {
                this.fireValueChange(Diffs.createValueDiff(this.updater.oldValue, this.cachedValue));
                this.cancelScheduledUpdate();
            }
        }
        return this.cachedValue;
    }

    @Override
    protected void doSetValue(T value) {
        this.updating = true;
        try {
            this.dirty = false;
            this.cancelScheduledUpdate();
            T oldValue = this.cachedValue;
            this.observable.setValue(value);
            this.cachedValue = this.internalGetValue();
            if (!Objects.equals(oldValue, this.cachedValue)) {
                this.fireValueChange(Diffs.createValueDiff(oldValue, this.cachedValue));
            }
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public boolean isStale() {
        ObservableTracker.getterCalled(this);
        return this.dirty && this.updater != null || this.observable.isStale();
    }

    @Override
    public Object getValueType() {
        return this.observable.getValueType();
    }

    @Override
    public synchronized void dispose() {
        this.cancelScheduledUpdate();
        if (this.observable != null) {
            this.observable.dispose();
            this.observable = null;
        }
        super.dispose();
    }

    private void makeDirty() {
        this.cancelScheduledUpdate();
        this.scheduleUpdate();
        if (!this.dirty) {
            this.dirty = true;
            this.fireStale();
        }
    }

    private void cancelScheduledUpdate() {
        if (this.updater != null) {
            this.updater.cancel();
            this.updater = null;
        }
    }

    private void scheduleUpdate() {
        this.updater = new ValueUpdater(this.cachedValue);
        this.getRealm().timerExec(this.delay, this.updater);
    }

    private void internalFireValueChange(final T oldValue) {
        this.cancelScheduledUpdate();
        this.fireValueChange(new ValueDiff<T>(){

            @Override
            public T getOldValue() {
                return oldValue;
            }

            @Override
            public T getNewValue() {
                return DelayedObservableValue.this.getValue();
            }
        });
    }

    class ValueUpdater
    implements Runnable {
        private final T oldValue;
        boolean cancel = false;
        boolean running = false;

        ValueUpdater(T oldValue) {
            this.oldValue = oldValue;
        }

        void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            if (!this.cancel) {
                try {
                    this.running = true;
                    DelayedObservableValue.this.internalFireValueChange(this.oldValue);
                }
                finally {
                    this.running = false;
                }
            }
        }
    }
}

