/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaas.callback;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jetty.security.jaas.callback.AbstractCallbackHandler;
import org.eclipse.jetty.security.jaas.callback.ObjectCallback;
import org.eclipse.jetty.security.jaas.callback.RequestCallback;
import org.eclipse.jetty.security.jaas.callback.RequestParameterCallback;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Fields;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request _request;

    public void setRequest(Request request) {
        this._request = request;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.getUserName());
                continue;
            }
            if (callback instanceof ObjectCallback) {
                ((ObjectCallback)callback).setObject(this.getCredential());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.getCredential().toString().toCharArray());
                continue;
            }
            if (callback instanceof RequestParameterCallback) {
                if (this._request == null) continue;
                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                Fields queryFields = Request.extractQueryParameters((Request)this._request);
                Fields formFields = (Fields)ExceptionUtil.get((CompletableFuture)FormFields.from((Request)this._request));
                Fields fields = Fields.combine((Fields)queryFields, (Fields)formFields);
                rpc.setParameterValues(fields.getValues(rpc.getParameterName()));
                continue;
            }
            if (callback instanceof RequestCallback) {
                ((RequestCallback)callback).setRequest(this._request);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

