/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.internal.services.ResourceBundleTranslationProvider;
import org.eclipse.e4.core.services.nls.IMessageFactoryService;
import org.eclipse.e4.core.services.nls.Message;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component
public class MessageFactoryServiceImpl
implements IMessageFactoryService {
    private LoggerFactory factory;
    private Logger logger;
    private final Map<Object, Reference<Object>> SOFT_CACHE = Collections.synchronizedMap(new HashMap());
    private final Map<Object, Reference<Object>> WEAK_CACHE = Collections.synchronizedMap(new HashMap());
    private int CLEANUPCOUNT = 0;

    @Override
    public <M> M getMessageInstance(Locale locale, Class<M> messages, ResourceBundleProvider provider) {
        String key = messages.getName() + "_" + String.valueOf(locale);
        Message annotation = messages.getAnnotation(Message.class);
        Map<Object, Reference<Object>> cache = null;
        Message.ReferenceType type = Message.ReferenceType.NONE;
        if (++this.CLEANUPCOUNT > 1000) {
            Iterator<Map.Entry<Object, Reference<Object>>> it = this.WEAK_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().get() != null) continue;
                it.remove();
            }
            it = this.SOFT_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().get() != null) continue;
                it.remove();
            }
            this.CLEANUPCOUNT = 0;
        }
        if (annotation == null || annotation.referenceType() == Message.ReferenceType.SOFT) {
            cache = this.SOFT_CACHE;
            type = Message.ReferenceType.SOFT;
        } else if (annotation.referenceType() == Message.ReferenceType.WEAK) {
            cache = this.WEAK_CACHE;
            type = Message.ReferenceType.WEAK;
        }
        if (cache != null && cache.containsKey(key)) {
            Reference<Object> ref = cache.get(key);
            Object o = ref.get();
            if (o != null) {
                return (M)o;
            }
            cache.remove(key);
        }
        Object instance = System.getSecurityManager() == null ? this.createInstance(locale, messages, annotation, provider) : AccessController.doPrivileged(() -> this.createInstance(locale, messages, annotation, provider));
        if (cache != null) {
            if (type == Message.ReferenceType.SOFT) {
                cache.put(key, new SoftReference<M>(instance));
            } else if (type == Message.ReferenceType.WEAK) {
                cache.put(key, new WeakReference<M>(instance));
            }
        }
        return instance;
    }

    private <M> M createInstance(Locale locale, Class<M> messages, Message annotation, ResourceBundleProvider rbProvider) {
        M instance;
        block14: {
            String baseName;
            ResourceBundle resourceBundle = null;
            if (annotation != null) {
                if (!annotation.contributionURI().isEmpty()) {
                    resourceBundle = ResourceBundleHelper.getResourceBundleForUri(annotation.contributionURI(), locale, rbProvider);
                } else if (!annotation.contributorURI().isEmpty()) {
                    Logger log = this.logger;
                    if (log != null) {
                        log.warn("Usage of @Message#contributorURI detected! Please use @Message#contributionURI instead!");
                    }
                    resourceBundle = ResourceBundleHelper.getResourceBundleForUri(annotation.contributorURI(), locale, rbProvider);
                }
            }
            if (resourceBundle == null && (resourceBundle = ResourceBundleHelper.getEquinoxResourceBundle(baseName = messages.getName().replace('.', '/'), locale, messages.getClassLoader())) == null) {
                resourceBundle = ResourceBundleHelper.getEquinoxResourceBundle(baseName.toLowerCase(), locale, messages.getClassLoader());
            }
            if (resourceBundle == null) {
                Bundle bundle = FrameworkUtil.getBundle(messages);
                resourceBundle = rbProvider.getResourceBundle(bundle, locale.toString());
            }
            ResourceBundleTranslationProvider provider = new ResourceBundleTranslationProvider(resourceBundle);
            instance = null;
            try {
                Field[] fields;
                instance = messages.newInstance();
                Field[] fieldArray = fields = messages.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (field.getType().isAssignableFrom(String.class)) {
                        field.set(instance, provider.translate(field.getName()));
                    }
                    ++n2;
                }
            }
            catch (InstantiationException e) {
                Logger log = this.logger;
                if (log != null) {
                    log.error("Instantiation of messages class failed", (Object)e);
                }
            }
            catch (IllegalAccessException e) {
                Logger log = this.logger;
                if (log == null) break block14;
                log.error("Failed to access messages class", (Object)e);
            }
        }
        this.processPostConstruct(instance, messages);
        return instance;
    }

    private void processPostConstruct(Object messageObject, Class<?> messageClass) {
        if (messageObject != null) {
            Method[] methods;
            Method[] methodArray = methods = messageClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(PostConstruct.class) || method.isAnnotationPresent(jakarta.annotation.PostConstruct.class)) {
                        try {
                            method.invoke(messageObject, new Object[0]);
                        }
                        catch (Exception e) {
                            Logger log = this.logger;
                            if (log == null) break block5;
                            log.error("Exception on trying to execute the @PostConstruct annotated method in {}", messageClass, (Object)e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(this.getClass());
    }

    void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }
}

