/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.interactiondesign.layout;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.ui.interactiondesign.layout.LayoutRegistry;
import org.eclipse.rap.ui.interactiondesign.layout.model.Layout;
import org.eclipse.rap.ui.interactiondesign.layout.model.LayoutSet;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class ElementBuilder
implements IAdaptable {
    private Composite parent;
    private Layout layout;
    private LayoutSet layoutSet;

    public ElementBuilder(Composite parent, String layoutSetId) {
        this.parent = parent;
        LayoutRegistry registry = LayoutRegistry.getInstance();
        String savedLayoutId = registry.getSavedLayoutId();
        if (!savedLayoutId.equals("")) {
            registry.setActiveLayout(savedLayoutId, false);
        }
        this.layout = registry.getActiveLayout();
        if (this.layout == null) {
            String msg = "no layout registered with default id (LayoutRegistry.DEFAULT_LAYOUT_ID) or no layout activated over branding extension.";
            throw new IllegalArgumentException(msg);
        }
        this.layoutSet = this.layout.getLayoutSet(layoutSetId);
        registry.registerBuilder(this);
    }

    public abstract void addControl(Control var1, Object var2);

    public abstract void addControl(Control var1, String var2);

    public abstract void addImage(Image var1, Object var2);

    public abstract void addImage(Image var1, String var2);

    public abstract void build();

    protected Image createImage(String path) {
        String id;
        Image result = null;
        if (path != null && (id = LayoutRegistry.getPluginIdForLayoutSet(this.layoutSet.getId())) != null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin(id, path);
            result = descriptor.createImage();
        }
        return result;
    }

    public abstract void dispose();

    public Color getColor(String colorId) {
        return this.layoutSet.getColor(colorId);
    }

    public FormData getPosition(String positionKey) {
        return this.layoutSet.getPosition(positionKey);
    }

    public abstract Control getControl();

    public Font getFont(String fontID) {
        return this.layoutSet.getFont(fontID);
    }

    public Image getImage(String imageId) {
        Image result = null;
        String imagePath = this.layoutSet.getImagePath(imageId);
        if (imagePath != null) {
            result = this.createImage(imagePath);
        }
        return result;
    }

    protected LayoutSet getLayoutSet() {
        return this.layoutSet;
    }

    protected Composite getParent() {
        return this.parent;
    }

    public abstract Point getSize();

    public Object getAdapter(Class adapter) {
        return null;
    }
}

