/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.IO;

public abstract class Resource
implements Iterable<Resource> {
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    public static String dump(Resource resource) {
        if (resource == null) {
            return "null exists=false directory=false lm=-1";
        }
        return "%s exists=%b directory=%b lm=%s".formatted(resource.toString(), resource.exists(), resource.isDirectory(), resource.lastModified());
    }

    public abstract Path getPath();

    public abstract boolean isContainedIn(Resource var1);

    @Override
    public Iterator<Resource> iterator() {
        return List.of(this).iterator();
    }

    public boolean exists() {
        return Files.exists(this.getPath(), NO_FOLLOW_LINKS);
    }

    public abstract boolean isDirectory();

    public abstract boolean isReadable();

    public Instant lastModified() {
        return Instant.EPOCH;
    }

    public long length() {
        return -1L;
    }

    public abstract URI getURI();

    public abstract String getName();

    public abstract String getFileName();

    public InputStream newInputStream() throws IOException {
        Path path = this.getPath();
        if (path == null) {
            return null;
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    public ReadableByteChannel newReadableByteChannel() throws IOException {
        Path path = this.getPath();
        if (path == null) {
            return null;
        }
        return Files.newByteChannel(this.getPath(), StandardOpenOption.READ);
    }

    public List<Resource> list() {
        return List.of();
    }

    public abstract Resource resolve(String var1);

    public boolean isAlias() {
        return false;
    }

    public URI getRealURI() {
        return this.getURI();
    }

    public void copyTo(Path destination) throws IOException {
        if (Files.exists(destination, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(destination) + " exists");
        }
        Path src = this.getPath();
        if (src != null) {
            Files.copy(src, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        try (InputStream in = this.newInputStream();
             OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);){
            IO.copy(in, out);
        }
    }

    public Collection<Resource> getAllResources() {
        try {
            ArrayList<Resource> deep = new ArrayList<Resource>();
            for (Resource r : this.list()) {
                if (r.isDirectory()) {
                    deep.addAll(r.getAllResources());
                    continue;
                }
                deep.add(r);
            }
            return deep;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

