/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.testfixture.internal.TestServletOutputStream;

public class TestResponse
implements HttpServletResponse {
    private TestServletOutputStream outStream = new TestServletOutputStream();
    private String contentType;
    private String characterEncoding = "UTF-8";
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private int errorStatus;
    private int status;
    private String redirect;
    private PrintWriter printWriter;

    public void addCookie(Cookie arg0) {
        this.cookies.put(arg0.getName(), arg0);
    }

    public Cookie getCookie(String cookieName) {
        return this.cookies.get(cookieName);
    }

    public boolean containsHeader(String arg0) {
        return false;
    }

    public String encodeURL(String arg0) {
        return arg0;
    }

    public String encodeRedirectURL(String arg0) {
        return arg0;
    }

    public String encodeUrl(String arg0) {
        return arg0;
    }

    public String encodeRedirectUrl(String arg0) {
        return arg0;
    }

    public void sendError(int code, String message) throws IOException {
        this.errorStatus = code;
        this.getWriter().write("HTTP ERROR " + code + "\nReason: " + message);
    }

    public void sendError(int code) throws IOException {
        this.errorStatus = code;
        this.getWriter().write("HTTP ERROR " + code);
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void sendRedirect(String arg0) throws IOException {
        this.redirect = arg0;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setDateHeader(String arg0, long arg1) {
        this.headers.put(arg0, new Date(arg1).toString());
    }

    public void addDateHeader(String arg0, long arg1) {
        this.headers.put(arg0, new Date(arg1).toString());
    }

    public void setHeader(String arg0, String arg1) {
        this.headers.put(arg0, arg1);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void addHeader(String arg0, String arg1) {
        this.headers.put(arg0, arg1);
    }

    public void setIntHeader(String arg0, int arg1) {
    }

    public void addIntHeader(String arg0, int arg1) {
    }

    public void setStatus(int arg0) {
        this.status = arg0;
    }

    public void setStatus(int arg0, String arg1) {
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.outStream), this.characterEncoding));
        }
        return this.printWriter;
    }

    public void setContentLength(int arg0) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.setHeader("Content-Type", contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
        this.setHeader("Content-Type", String.valueOf(this.contentType) + "; charset=" + charset);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setBufferSize(int arg0) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale arg0) {
    }

    public Locale getLocale() {
        return null;
    }

    public String getContent() {
        String result = "";
        if (this.printWriter != null) {
            this.printWriter.flush();
            ByteArrayOutputStream content = this.outStream.getContent();
            try {
                result = content.toString(this.characterEncoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw new RuntimeException(exception);
            }
        }
        return result;
    }

    public void clearContent() {
        this.outStream = new TestServletOutputStream();
        this.printWriter = null;
    }

    public int getStatus() {
        return this.status;
    }

    public Collection<String> getHeaders(String name) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }
}

