/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.IMenuAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.internal.widgets.menukit.MenuLCA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    private transient IMenuAdapter menuAdapter;
    private final ItemHolder<MenuItem> itemHolder;
    private final Decorations parent;
    private int x;
    private int y;
    private boolean visible = false;
    private boolean hasLocation = false;
    MenuItem cascade;

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem parent) {
        this(Menu.checkNull(parent).getParent().getParent(), 4);
    }

    public Menu(Control parent) {
        this(Menu.checkNull(parent).getShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.itemHolder = new ItemHolder<MenuItem>(MenuItem.class);
        parent.getAdapter(MenuHolder.class).addMenu(this);
        this.checkOrientation(parent);
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.getParent();
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IItemHolderAdapter.class) {
            return (T)this.itemHolder;
        }
        if (adapter == IMenuAdapter.class) {
            if (this.menuAdapter == null) {
                this.menuAdapter = new IMenuAdapter(){

                    @Override
                    public Point getLocation() {
                        return new Point(Menu.this.x, Menu.this.y);
                    }
                };
            }
            return (T)this.menuAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)MenuLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) == 0) {
            this.x = x;
            this.y = y;
            this.hasLocation = true;
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if ((this.style & 6) == 0) {
            int flags = 0x6000000;
            if ((orientation & flags) == 0 || (orientation & flags) == flags) {
                return;
            }
            this.style &= ~flags;
            this.style |= orientation & flags;
        }
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) == 0 && this.visible != visible) {
            this.visible = visible;
            if (visible) {
                if (!this.hasLocation) {
                    this.setLocation(this.getDisplay().getCursorLocation());
                }
                this.hasLocation = false;
                this.notifyListeners(22, new Event());
            }
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        boolean result = (this.style & 2) != 0 ? this == this.parent.getMenuBar() : ((this.style & 8) != 0 ? this.visible : false);
        return result;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.removeState(8);
        if (!enabled) {
            this.addState(8);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return !this.hasState(8);
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        return (MenuItem[])this.itemHolder.getItems();
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        return this.itemHolder.getItem(index);
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            SWT.error(4);
        }
        if (menuItem.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(menuItem);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    @Override
    final void releaseChildren() {
        MenuItem[] menuItems = (MenuItem[])this.itemHolder.getItems();
        int i = 0;
        while (i < menuItems.length) {
            menuItems[i].dispose();
            ++i;
        }
        super.releaseChildren();
    }

    @Override
    final void releaseWidget() {
        this.parent.getAdapter(MenuHolder.class).removeMenu(this);
        super.releaseWidget();
    }

    @Override
    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(22, typedListener);
        this.addListener(23, typedListener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(22, listener);
        this.removeListener(23, listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(28, listener);
    }

    private static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    private static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    private static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    private static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    @Override
    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }
}

