/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.demo.parts;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EventSamplePart {
    @Inject
    IEventBroker broker;
    @Inject
    UISynchronize uiSync;
    private ListViewer listViewer;

    @PostConstruct
    void init(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.listViewer = new ListViewer(parent);
        this.listViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createSendGroup(parent, "EventTopic");
        this.createSendGroup(parent, "UIEventTopic");
    }

    private void createSendGroup(Composite parent, final String topicType) {
        Group g = new Group(parent, 0);
        g.setText("@" + topicType);
        g.setLayout((Layout)new GridLayout(2, true));
        g.setLayoutData((Object)new GridData(768));
        Button b = new Button((Composite)g, 8);
        b.setText("Sync sending");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventSamplePart.this.broker.send("rape4/" + topicType, (Object)("@" + topicType + " - Event at " + System.currentTimeMillis()));
            }
        });
        b.setLayoutData((Object)new GridData(768));
        b = new Button((Composite)g, 8);
        b.setText("Async sending");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventSamplePart.this.broker.post("rape4/" + topicType, (Object)("@" + topicType + " - Event at " + System.currentTimeMillis()));
            }
        });
        b.setLayoutData((Object)new GridData(768));
    }

    @Inject
    @Optional
    void receiveEvent(final @EventTopic(value="rape4/EventTopic") String eventData) {
        if (this.listViewer.getControl().getDisplay().getThread() == Thread.currentThread()) {
            this.listViewer.add((Object)eventData);
        } else {
            this.uiSync.syncExec(new Runnable(){

                @Override
                public void run() {
                    EventSamplePart.this.listViewer.add((Object)eventData);
                }
            });
        }
    }

    @Inject
    @Optional
    void receiveUIEvent(@UIEventTopic(value="rape4/UIEventTopic") String eventData) {
        this.listViewer.add((Object)eventData);
    }
}

