/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.Infobox;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MarkupLabelExample
implements IExamplePage {
    private static final String DEFAULT_TEXT = "<small>One morning, when Gregor Samsa woke from <em style='color:rgb(255,100,0)'>troubled dreams</em>, he found himself transformed in his bed into a <strong>horrible vermin</strong>.</small>\n\n<br/><br/>\n\nHe lay on his armour-like back, and if <a href='http://en.wikipedia.org/wiki/The_Metamorphosis'>he lifted his head</a> a little he could see his brown belly, slightly domed and divided by arches into stiff sections.";
    private static final String ERROR_MESSAGE = "Oooops. Found invalid markup. Please check your label text.";
    private Label markupLabel;
    private Label errorLabel;
    private Text multilineText;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)3));
        this.createLeftArea(parent);
        this.createCenterArea(parent);
        this.createRightArea(parent);
    }

    private void createLeftArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        comp.setLayoutData((Object)ExampleUtil.createFillData());
        this.markupLabel = this.createMarkupLabel(comp);
    }

    private void createCenterArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)true, (boolean)true, (boolean)true));
        comp.setLayoutData((Object)ExampleUtil.createHorzFillData());
        this.multilineText = this.createMultilineText(comp);
        this.createButtons(comp);
        this.errorLabel = this.createErrorLabel(comp);
        this.errorLabel.setVisible(false);
    }

    private void createRightArea(Composite parent) {
        Infobox infobox = new Infobox(parent);
        infobox.addParagraph("Since RAP 1.5 the Label, Table and Tree support markup. Use common html elements to tag portions of a label's text and change it's appearance with inline css.");
        infobox.addHeading("Supported tags are:");
        infobox.addParagraph("html, br, b, strong, i, em, sub, sup, big, small, del, ins, code, samp, kbd, var, cite, dfn, q, abbr, span, img, a.");
    }

    private Label createMarkupLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"markup");
        label.setText(DEFAULT_TEXT);
        label.setLayoutData((Object)ExampleUtil.createFillData());
        return label;
    }

    private Label createErrorLabel(Composite comp) {
        Label label = new Label(comp, 64);
        label.setText(ERROR_MESSAGE);
        GridData layoutData = ExampleUtil.createHorzFillData();
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"error");
        return label;
    }

    private Text createMultilineText(Composite parent) {
        Text text = new Text(parent, 2114);
        GridData layoutData = ExampleUtil.createHorzFillData();
        layoutData.horizontalSpan = 2;
        layoutData.heightHint = 300;
        text.setLayoutData((Object)layoutData);
        text.setText(DEFAULT_TEXT);
        return text;
    }

    private void createButtons(Composite parent) {
        this.createChangeTextButton(parent);
        this.createResetButton(parent);
    }

    private void createChangeTextButton(Composite parent) {
        Button changeTextButton = new Button(parent, 8);
        changeTextButton.setLayoutData((Object)ExampleUtil.createHorzFillData());
        changeTextButton.setText("change label text");
        changeTextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    MarkupLabelExample.this.markupLabel.setText(MarkupLabelExample.this.multilineText.getText());
                    MarkupLabelExample.this.multilineText.setData("org.eclipse.rap.rwt.customVariant", null);
                    MarkupLabelExample.this.errorLabel.setVisible(false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MarkupLabelExample.this.multilineText.setData("org.eclipse.rap.rwt.customVariant", (Object)"error");
                    MarkupLabelExample.this.errorLabel.setVisible(true);
                }
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button resetButton = new Button(parent, 8);
        resetButton.setLayoutData((Object)ExampleUtil.createHorzFillData());
        resetButton.setText("reset");
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MarkupLabelExample.this.markupLabel.setText(MarkupLabelExample.DEFAULT_TEXT);
                MarkupLabelExample.this.multilineText.setText(MarkupLabelExample.DEFAULT_TEXT);
                MarkupLabelExample.this.multilineText.setData("org.eclipse.rap.rwt.customVariant", null);
                MarkupLabelExample.this.errorLabel.setVisible(false);
            }
        });
    }
}

