/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rap.rwt.internal.theme.ThemeResource;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceLoader;

public class CssCursor
implements CssValue,
ThemeResource {
    private static final String CURSOR_DEST_PATH = "themes/cursors";
    private static final String[] PREDEFINED_CURSORS = new String[]{"default", "wait", "crosshair", "help", "move", "text", "pointer", "e-resize", "n-resize", "w-resize", "s-resize", "ne-resize", "se-resize", "nw-resize", "sw-resize", "col-resize", "row-resize", "progress", "not-allowed", "no-drop"};
    public final String value;
    public final ResourceLoader loader;

    private CssCursor(String value, ResourceLoader loader) {
        this.value = value;
        this.loader = loader;
        if (this.isCustomCursor()) {
            try {
                InputStream inputStream = loader.getResourceAsStream(value);
                if (inputStream == null) {
                    throw new IllegalArgumentException("Failed to read cursor '" + value + "'");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read cursor " + value + ": " + e.getMessage());
            }
        }
    }

    public static CssCursor valueOf(String input, ResourceLoader loader) {
        if (input == null || loader == null) {
            throw new NullPointerException("null argument");
        }
        if (input.length() == 0) {
            throw new IllegalArgumentException("Empty cursor path");
        }
        return new CssCursor(input, loader);
    }

    public static CssCursor valueOf(String input) {
        if (!CssCursor.isPredefinedCursor(input)) {
            throw new IllegalArgumentException("Invalid value for cursor: " + input);
        }
        return new CssCursor(input, null);
    }

    public static boolean isPredefinedCursor(String value) {
        boolean result = false;
        int i = 0;
        while (i < PREDEFINED_CURSORS.length && !result) {
            if (PREDEFINED_CURSORS[i].equalsIgnoreCase(value)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean isCustomCursor() {
        return !CssCursor.isPredefinedCursor(this.value);
    }

    @Override
    public String getResourcePath(ApplicationContext applicationContext) {
        String result = null;
        if (this.isCustomCursor()) {
            ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance(applicationContext);
            ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(CssCursor.class);
            String cssKey = adapter.getKey(this);
            result = "themes/cursors/" + cssKey;
        }
        return result;
    }

    @Override
    public InputStream getResourceAsStream() throws IOException {
        InputStream inputStream = null;
        if (this.isCustomCursor()) {
            inputStream = this.loader.getResourceAsStream(this.value);
        }
        return inputStream;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssCursor) {
            CssCursor other = (CssCursor)object;
            return (this.value == null ? other.value == null : this.value.equals(other.value)) && (this.loader == null ? other.loader == null : this.loader.equals(other.loader));
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toDefaultString() {
        return this.isCustomCursor() ? "" : this.value;
    }

    public String toString() {
        return "CssCursor{ " + this.value + " }";
    }
}

