/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.CommandProcessor;
import org.eclipse.equinox.console.telnet.TelnetConnection;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelnetServer
extends Thread {
    private ServerSocket server;
    private boolean isRunning = true;
    private List<CommandProcessor> processors = null;
    private BundleContext context;
    private List<Socket> sockets = new ArrayList<Socket>();
    private Map<CommandProcessor, List<TelnetConnection>> processorToConnectionsMapping = new HashMap<CommandProcessor, List<TelnetConnection>>();

    public TelnetServer(BundleContext context, List<CommandProcessor> processors, String host, int port) throws IOException {
        this.context = context;
        this.processors = processors;
        this.server = host != null ? new ServerSocket(port, 0, InetAddress.getByName(host)) : new ServerSocket(port);
    }

    @Override
    public void run() {
        block18: {
            try {
                try {
                    while (this.isRunning) {
                        Socket socket = this.server.accept();
                        this.sockets.add(socket);
                        for (CommandProcessor processor : this.processors) {
                            TelnetConnection telnetConnection = new TelnetConnection(socket, processor, this.context);
                            List<TelnetConnection> telnetConnections = this.processorToConnectionsMapping.get(processor);
                            if (telnetConnections == null) {
                                telnetConnections = new ArrayList<TelnetConnection>();
                                this.processorToConnectionsMapping.put(processor, telnetConnections);
                            }
                            telnetConnections.add(telnetConnection);
                            telnetConnection.start();
                        }
                    }
                }
                catch (IOException e) {
                    if (this.isRunning) {
                        e.printStackTrace();
                    }
                    this.isRunning = false;
                    try {
                        if (this.server != null) {
                            this.server.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.isRunning = false;
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            this.isRunning = false;
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void addCommandProcessor(CommandProcessor processor) {
        this.processors.add(processor);
        if (!this.sockets.isEmpty()) {
            ArrayList<TelnetConnection> telnetConnections = new ArrayList<TelnetConnection>();
            for (Socket socket : this.sockets) {
                TelnetConnection telnetConnection = new TelnetConnection(socket, processor, this.context);
                telnetConnections.add(telnetConnection);
                telnetConnection.start();
            }
            this.processorToConnectionsMapping.put(processor, telnetConnections);
        }
    }

    public synchronized void removeCommandProcessor(CommandProcessor processor) {
        this.processors.remove(processor);
        List<TelnetConnection> telnetConnections = this.processorToConnectionsMapping.remove(processor);
        if (telnetConnections != null) {
            for (TelnetConnection telnetConnection : telnetConnections) {
                telnetConnection.close();
            }
        }
    }

    public synchronized void stopTelnetServer() {
        this.isRunning = false;
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {}
        for (List<TelnetConnection> telnetConnections : this.processorToConnectionsMapping.values()) {
            for (TelnetConnection telnetConnection : telnetConnections) {
                telnetConnection.close();
            }
        }
        this.interrupt();
    }
}

