/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetDataUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public final class WidgetUtil {
    private WidgetUtil() {
    }

    public static RemoteAdapter getAdapter(Widget widget) {
        RemoteAdapter adapter = widget.getAdapter(RemoteAdapter.class);
        if (adapter == null) {
            throw new IllegalStateException("Could not retrieve an instance of WidgetAdapter.");
        }
        return adapter;
    }

    public static String getId(Widget widget) {
        return WidgetUtil.getAdapter(widget).getId();
    }

    public static String getVariant(Widget widget) {
        return (String)widget.getData("org.eclipse.rap.rwt.customVariant");
    }

    public static AbstractWidgetLCA getLCA(Widget widget) {
        AbstractWidgetLCA lca = (AbstractWidgetLCA)widget.getAdapter(WidgetLifeCycleAdapter.class);
        if (lca == null) {
            throw new IllegalStateException("Could not retrieve an instance of WidgetLifeCycleAdapter.");
        }
        return lca;
    }

    public static Widget find(Composite root, final String id) {
        final Widget[] result = new Widget[1];
        if (id != null) {
            WidgetTreeVisitor.accept(root, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                @Override
                public boolean doVisit(Widget widget) {
                    if (WidgetUtil.getId(widget).equals(id)) {
                        result[0] = widget;
                    }
                    return result[0] == null;
                }
            });
        }
        return result[0];
    }

    public static void registerDataKeys(String ... keys) {
        ParamCheck.notNull(keys, "keys");
        WidgetDataUtil.registerDataKeys(keys);
    }
}

