/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabfolderkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.tabfolderkit.TabFolderOperationHandler;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;

public class TabFolderLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.TabFolder";
    private static final String[] ALLOWED_STYLES = new String[]{"TOP", "BOTTOM", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    @Override
    public void preserveValues(Widget widget) {
        TabFolder folder = (TabFolder)widget;
        ControlLCAUtil.preserveValues(folder);
        WidgetLCAUtil.preserveCustomVariant(folder);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION, TabFolderLCA.getSelection(folder));
    }

    @Override
    public void renderInitialization(Widget widget) throws IOException {
        TabFolder folder = (TabFolder)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(folder, TYPE);
        remoteObject.setHandler(new TabFolderOperationHandler(folder));
        remoteObject.set("parent", WidgetUtil.getId(folder.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(folder, ALLOWED_STYLES)));
        remoteObject.listen(PROP_SELECTION_LISTENER, true);
    }

    @Override
    public void renderChanges(Widget widget) throws IOException {
        TabFolder folder = (TabFolder)widget;
        ControlLCAUtil.renderChanges(folder);
        WidgetLCAUtil.renderCustomVariant(folder);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION, TabFolderLCA.getSelection(folder), null);
    }

    private static String getSelection(TabFolder folder) {
        String selection = null;
        int selectionIndex = folder.getSelectionIndex();
        if (selectionIndex != -1) {
            selection = WidgetUtil.getId(folder.getItem(selectionIndex));
        }
        return selection;
    }
}

