/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public final class ItemHolder<T extends Item>
implements IItemHolderAdapter<T>,
SerializableCompatibility {
    private final List<T> items;
    private final Class type;

    public static <T extends Item> IItemHolderAdapter<T> getItemHolder(Widget widget) {
        if (!ItemHolder.isItemHolder(widget)) {
            String txt = "Widget type does not contain items: " + widget.getClass().getName();
            throw new IllegalArgumentException(txt);
        }
        return widget.getAdapter(IItemHolderAdapter.class);
    }

    public static boolean isItemHolder(Widget widget) {
        return widget.getAdapter(IItemHolderAdapter.class) != null;
    }

    public ItemHolder(Class<T> type) {
        this.type = type;
        this.items = new ArrayList<T>();
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public void add(T item) {
        if (item == null) {
            SWT.error(4);
        }
        if (this.items.contains(item)) {
            String msg = "The item was already added.";
            throw new IllegalArgumentException(msg);
        }
        this.items.add(item);
    }

    @Override
    public void insert(T item, int index) {
        if (item == null) {
            SWT.error(4);
        }
        if (index < 0 || index > this.size()) {
            SWT.error(6);
        }
        if (this.items.contains(item)) {
            throw new IllegalArgumentException("The item was already added.");
        }
        this.items.add(index, item);
    }

    @Override
    public void remove(T item) {
        if (item == null) {
            SWT.error(4);
        }
        if (!this.items.contains(item)) {
            throw new IllegalArgumentException("The item was not added to this item holder.");
        }
        this.items.remove(item);
    }

    @Override
    public T[] getItems() {
        Item[] result = (Item[])Array.newInstance(this.type, this.items.size());
        return this.items.toArray(result);
    }

    public T getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        return (T)((Item)this.items.get(index));
    }

    public int indexOf(T item) {
        return this.items.indexOf(item);
    }
}

