/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.scrolledcompositekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.custom.scrolledcompositekit.ScrolledCompositeOperationHandler;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrolledCompositeLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ScrolledComposite";
    private static final String[] ALLOWED_STYLES = new String[]{"H_SCROLL", "V_SCROLL", "BORDER"};
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_SHOW_FOCUSED_CONTROL = "showFocusedControl";
    private static final Point DEFAULT_ORIGIN = new Point(0, 0);

    @Override
    public void preserveValues(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.preserveValues(composite);
        WidgetLCAUtil.preserveCustomVariant(composite);
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_ORIGIN, ScrolledCompositeLCA.getOrigin(composite));
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_CONTENT, composite.getContent());
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl());
        ScrollBarLCAUtil.preserveValues(composite);
    }

    @Override
    public void readData(Widget widget) {
        super.readData(widget);
        ScrollBarLCAUtil.processSelectionEvent((ScrolledComposite)widget);
    }

    @Override
    public void renderInitialization(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(composite, TYPE);
        remoteObject.setHandler(new ScrolledCompositeOperationHandler(composite));
        remoteObject.set("parent", WidgetUtil.getId(composite.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(composite, ALLOWED_STYLES)));
        ScrollBarLCAUtil.renderInitialization(composite);
    }

    @Override
    public void renderChanges(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.renderChanges(composite);
        WidgetLCAUtil.renderCustomVariant(composite);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_CONTENT, composite.getContent(), null);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_ORIGIN, ScrolledCompositeLCA.getOrigin(composite), DEFAULT_ORIGIN);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl(), false);
        ScrollBarLCAUtil.renderChanges(composite);
    }

    private static Point getOrigin(ScrolledComposite composite) {
        ScrollBar verticalBar;
        Point result = new Point(0, 0);
        ScrollBar horizontalBar = composite.getHorizontalBar();
        if (horizontalBar != null) {
            result.x = horizontalBar.getSelection();
        }
        if ((verticalBar = composite.getVerticalBar()) != null) {
            result.y = verticalBar.getSelection();
        }
        return result;
    }
}

