/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.preferences;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.FileSettingStore;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.rwt.service.SettingStoreException;
import org.osgi.framework.Bundle;

public final class WorkbenchFileSettingStoreFactory
implements ISettingStoreFactory {
    public ISettingStore createSettingStore(String storeId) {
        ParamCheck.notNullOrEmpty((String)storeId, (String)"storeId");
        FileSettingStore result = new FileSettingStore(this.getWorkDir());
        try {
            result.loadById(storeId);
        }
        catch (SettingStoreException sse) {
            String msg = String.valueOf(sse.getMessage());
            RWT.getRequest().getSession().getServletContext().log(msg, (Throwable)sse);
        }
        return result;
    }

    private File getWorkDir() {
        File result = this.getWorkDirFromEnvironment();
        if (result == null) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
            IPath stateLoc = Platform.getStateLocation((Bundle)bundle);
            File parentDir = stateLoc.toFile();
            result = new File(parentDir, FileSettingStore.class.getName());
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private File getWorkDirFromEnvironment() {
        String path = System.getProperty("org.eclipse.rwt.service.FileSettingStore.dir");
        return path != null ? new File(path) : null;
    }
}

