/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.event;

import java.security.PrivilegedAction;
import org.eclipse.equinox.internal.util.UtilActivator;

class PrivilegedActionImpl
implements PrivilegedAction {
    private ThreadGroup group;
    private Runnable runnable;
    private String name;
    private boolean locked = false;
    private int waiting = 0;

    PrivilegedActionImpl() {
    }

    void set(ThreadGroup group, Runnable runnable, String name) {
        this.lock();
        this.group = group;
        this.runnable = runnable;
        this.name = name;
    }

    public Object run() {
        ThreadGroup group = this.group;
        Runnable runnable = this.runnable;
        String name = this.name;
        this.unlock();
        Thread th = new Thread(group, runnable, name);
        if (!UtilActivator.getBoolean("equinox.disableContextClassLoader")) {
            th.setContextClassLoader(null);
        }
        th.setDaemon(false);
        return th;
    }

    private synchronized void lock() {
        while (this.locked) {
            try {
                ++this.waiting;
                this.wait();
                --this.waiting;
            }
            catch (Exception exception) {}
        }
        this.locked = true;
    }

    private synchronized void unlock() {
        this.locked = false;
        this.group = null;
        this.runnable = null;
        this.name = null;
        if (this.waiting > 0) {
            this.notifyAll();
        }
    }
}

