/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.provisional.LoadTargetDefinitionJob;
import org.eclipse.rap.ui.internal.intro.ErrorUtil;
import org.eclipse.rap.ui.internal.intro.IntroPlugin;
import org.eclipse.rap.ui.internal.intro.target.ContainerCreator;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;

public final class TargetSwitcher {
    private static final String TARGET_NAME_PATTERN = "RAP Runtime - {0}";
    private static final String VM_ARGS = "-Dosgi.noShutdown=true -Declipse.ignoreApp=true";
    private static final String PROGRAM_ARGS = "-console -consolelog";
    private static final String WS_RAP = "rap";
    static /* synthetic */ Class class$0;

    private TargetSwitcher() {
    }

    public static void switchTarget(ITargetDefinition target) throws CoreException {
        try {
            LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
            job.setUser(true);
            job.schedule();
            job.join();
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException e) {
            String msg = IntroMessages.InstallRAPTargetHandler_SwitchTargetInterrupted;
            ErrorUtil.log(msg, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITargetDefinition install(String targetRepositoryURI, String[] rootIUs, String targetQualifier, boolean switchTarget, IProgressMonitor monitor) throws CoreException {
        ITargetDefinition target = null;
        monitor.beginTask(IntroMessages.TargetProvider_Installing, -1);
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            SubMonitor targetMonitor = subMonitor.newChild(5);
            SubMonitor downloadMonitor = subMonitor.newChild(95);
            ITargetPlatformService service = TargetSwitcher.getTargetPlatformService();
            target = TargetSwitcher.createTargetDefinition(targetRepositoryURI, rootIUs, targetQualifier, service, (IProgressMonitor)targetMonitor);
            IStatus downloadStatus = TargetSwitcher.downloadTarget(target, (IProgressMonitor)downloadMonitor);
            if (downloadStatus.isOK()) {
                TargetSwitcher.saveTarget(service, target);
                if (switchTarget) {
                    TargetSwitcher.switchTarget(target);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        monitor.done();
        return target;
    }

    private static ITargetDefinition createTargetDefinition(String targetRepositoryURI, String[] rootIUs, String targetQualifier, ITargetPlatformService service, IProgressMonitor monitor) throws CoreException {
        String targetName = TargetSwitcher.getTargetName(targetQualifier);
        ITargetDefinition target = TargetSwitcher.getExistingTarget(service, targetName);
        if (target == null) {
            target = service.newTarget();
        }
        target.setName(targetName);
        target.setProgramArguments(PROGRAM_ARGS);
        target.setVMArguments(VM_ARGS);
        IUBundleContainer bundleContainer = TargetSwitcher.getBundleContainer(service, targetRepositoryURI, rootIUs, monitor);
        target.setBundleContainers(new IBundleContainer[]{bundleContainer});
        return target;
    }

    private static ITargetDefinition getExistingTarget(ITargetPlatformService service, String targetName) throws CoreException {
        ITargetDefinition result = null;
        ITargetHandle[] targets = service.getTargets((IProgressMonitor)new NullProgressMonitor());
        if (targets != null) {
            int i = 0;
            while (i < targets.length && result == null) {
                ITargetDefinition targetDefinition = targets[i].getTargetDefinition();
                if (targetName.equalsIgnoreCase(targetDefinition.getName())) {
                    result = targetDefinition;
                }
                ++i;
            }
        }
        return result;
    }

    private static IStatus downloadTarget(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        IStatus status = target.resolve(monitor);
        if (!status.isOK()) {
            Throwable statusException = TargetSwitcher.getDownloadException(status);
            if (statusException instanceof UnknownHostException) {
                String message = IntroMessages.TargetSwitcher_NoInternetConnectionAvailableErrorMsg;
                status = ErrorUtil.createErrorStatus(message, statusException);
            } else if (statusException instanceof SocketTimeoutException) {
                String message = IntroMessages.TargetSwitcher_TargetRepositoryProblemErrorMsg;
                status = ErrorUtil.createErrorStatus(message, statusException);
            }
            throw new CoreException(status);
        }
        return status;
    }

    private static void saveTarget(ITargetPlatformService service, ITargetDefinition target) throws CoreException {
        service.saveTargetDefinition(target);
    }

    private static IUBundleContainer getBundleContainer(ITargetPlatformService service, String p2RepositoryURI, String[] rootIUs, IProgressMonitor monitor) throws CoreException {
        IUBundleContainer container = null;
        try {
            container = TargetSwitcher.createContainer(service, p2RepositoryURI, rootIUs, monitor);
        }
        catch (URISyntaxException e) {
            String msg = IntroMessages.TargetSwitcher_InvalidTargetRepository;
            Object[] args = new Object[]{p2RepositoryURI};
            String fmtMsg = MessageFormat.format(msg, args);
            IStatus errorStatus = ErrorUtil.createErrorStatus(fmtMsg, e);
            throw new CoreException(errorStatus);
        }
        catch (Exception e) {
            String msg = IntroMessages.TargetSwitcher_TargetDefinitionErrorMsg;
            IStatus errorStatus = ErrorUtil.createErrorStatus(msg, e);
            throw new CoreException(errorStatus);
        }
        return container;
    }

    private static IUBundleContainer createContainer(ITargetPlatformService service, String p2RepositoryURI, String[] rootIUs, IProgressMonitor monitor) throws Exception {
        URI[] p2Repos = new URI[]{new URI(p2RepositoryURI)};
        String[] versions = TargetSwitcher.getLatestVersions(rootIUs, p2Repos[0], monitor);
        ContainerCreator creator = ContainerCreator.getInstance();
        IUBundleContainer container = creator.createContainer(rootIUs, versions, p2Repos, service);
        return container;
    }

    private static String[] getLatestVersions(String[] rootIUs, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        IProvisioningAgent agent = TargetSwitcher.getAgent();
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository metadataRepository = TargetSwitcher.loadRepository(p2RepositoryURI, repoManager, monitor);
        String[] result = TargetSwitcher.selectLatestVersions(rootIUs, metadataRepository);
        return result;
    }

    public static IProvisioningAgent getAgent() throws CoreException {
        IntroPlugin introPlugin = IntroPlugin.getDefault();
        IPath stateLocation = introPlugin.getStateLocation();
        URI stateLocationURI = stateLocation.toFile().toURI();
        IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)introPlugin.acquireService(IProvisioningAgentProvider.SERVICE_NAME);
        if (agentProvider == null) {
            String message = "Agent provider service not available";
            IStatus status = ErrorUtil.createErrorStatus(message, null);
            throw new CoreException(status);
        }
        return agentProvider.createAgent(stateLocationURI);
    }

    private static IMetadataRepository loadRepository(URI p2RepositoryURI, IMetadataRepositoryManager repoManager, IProgressMonitor monitor) throws CoreException {
        IMetadataRepository result;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            SubMonitor repositoryMonitor = subMonitor.newChild(1);
            result = repoManager.loadRepository(p2RepositoryURI, (IProgressMonitor)repositoryMonitor);
        }
        catch (ProvisionException e) {
            String message = "Failed to load repository <{0}>";
            Object[] arguments = new Object[]{p2RepositoryURI};
            String fmtMessage = MessageFormat.format(message, arguments);
            IStatus status = ErrorUtil.createErrorStatus(fmtMessage, e);
            throw new CoreException(status);
        }
        return result;
    }

    private static String[] selectLatestVersions(String[] rootIUs, IMetadataRepository metadataRepository) throws CoreException {
        String[] result = new String[rootIUs.length];
        int i = 0;
        while (i < rootIUs.length) {
            String rootIuId = rootIUs[i];
            IQuery latestQuery = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)rootIuId));
            IQueryResult queryResult = metadataRepository.query(latestQuery, (IProgressMonitor)new NullProgressMonitor());
            if (queryResult.isEmpty()) {
                String messag = "Feature <{0}> not found";
                Object[] arguments = new Object[]{rootIuId};
                String fmtMessage = MessageFormat.format(messag, arguments);
                IStatus status = ErrorUtil.createErrorStatus(fmtMessage, null);
                throw new CoreException(status);
            }
            Iterator iterator = queryResult.iterator();
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            result[i] = iu.getVersion().toString();
            ++i;
        }
        return result;
    }

    private static ITargetPlatformService getTargetPlatformService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String className = clazz.getName();
        PDECore pdeCore = PDECore.getDefault();
        return (ITargetPlatformService)pdeCore.acquireService(className);
    }

    private static String getTargetName(String targetQualifier) {
        Object[] args = new String[]{targetQualifier};
        return MessageFormat.format(TARGET_NAME_PATTERN, args);
    }

    private static Throwable getDownloadException(IStatus status) {
        Throwable result = status.getException();
        IStatus[] children = status.getChildren();
        if (result == null && children != null) {
            int i = 0;
            while (i < children.length && result == null) {
                result = TargetSwitcher.getDownloadException(children[i]);
                ++i;
            }
        }
        return result;
    }
}

