/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class SQLCall
extends DatabaseCall
implements QueryStringCall {
    protected boolean hasCustomSQLArguments = false;

    public SQLCall() {
    }

    public SQLCall(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    protected void afterTranslateCustomQuery(Vector updatedParameters, Vector updatedParameterTypes) {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            DatabaseField field;
            Integer parameterType = (Integer)this.getParameterTypes().elementAt(i);
            Object parameter = this.getParameters().elementAt(i);
            if (parameterType == MODIFY || parameterType == OUT || parameterType == OUT_CURSOR || parameterType == IN && parameter instanceof DatabaseField) {
                field = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)parameter, i, parameterType, updatedParameters, updatedParameterTypes);
                if (field == null) continue;
                this.getParameters().setElementAt(field, i);
                continue;
            }
            if (parameterType == INOUT) {
                DatabaseField outField = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)((Object[])parameter)[1], i, parameterType, updatedParameters, updatedParameterTypes);
                if (outField == null) continue;
                if (((Object[])parameter)[0] instanceof DatabaseField) {
                    if (((Object[])parameter)[0] != ((Object[])parameter)[1]) {
                        DatabaseField inField = (DatabaseField)outField.clone();
                        inField.setName(((DatabaseField)((Object[])parameter)[0]).getName());
                        ((Object[])parameter)[0] = inField;
                    } else {
                        ((Object[])parameter)[0] = outField;
                    }
                }
                ((Object[])parameter)[1] = outField;
                continue;
            }
            if (parameterType != IN || !(parameter instanceof DatabaseField) || (field = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)parameter, i, parameterType, updatedParameters, updatedParameterTypes)) == null) continue;
            this.getParameters().setElementAt(field, i);
        }
    }

    protected DatabaseField afterTranslateCustomQueryUpdateParameter(DatabaseField field, int index, Integer parameterType, Vector updatedParameters, Vector updatedParameterTypes) {
        for (int j = 0; j < updatedParameters.size(); ++j) {
            DatabaseField updateField = (DatabaseField)updatedParameters.elementAt(j);
            if (!field.equals(updateField)) continue;
            Integer updateParameterType = (Integer)updatedParameterTypes.elementAt(j);
            if (updateParameterType == null) {
                return updateField;
            }
            if (updateParameterType != OUT_CURSOR) break;
            if (parameterType == OUT) {
                this.getParameterTypes().setElementAt(OUT_CURSOR, index);
                return updateField;
            }
            throw ValidationException.cannotSetCursorForParameterTypeOtherThanOut(field.getName(), this.toString());
        }
        return null;
    }

    public boolean hasCustomSQLArguments() {
        return this.hasCustomSQLArguments;
    }

    public boolean isSQLCall() {
        return true;
    }

    public boolean isQueryStringCall() {
        return true;
    }

    protected void prepareInternal(AbstractSession session) {
        if (this.hasCustomSQLArguments()) {
            Vector updatedParameters = null;
            Vector updatedParameterTypes = null;
            if (this.getParameters().size() > 0) {
                updatedParameters = this.getParameters();
                this.setParameters(NonSynchronizedVector.newInstance());
                updatedParameterTypes = this.getParameterTypes();
                this.setParameterTypes(NonSynchronizedVector.newInstance());
            }
            this.translateCustomQuery();
            if (updatedParameters != null) {
                this.afterTranslateCustomQuery(updatedParameters, updatedParameterTypes);
            }
        }
        super.prepareInternal(session);
    }

    public void setHasCustomSQLArguments(boolean hasCustomSQLArguments) {
        this.hasCustomSQLArguments = hasCustomSQLArguments;
    }

    public void setCustomSQLArgumentType(String customParameterName, Class type) {
        DatabaseField field = new DatabaseField(customParameterName);
        field.setType(type);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type) {
        DatabaseField field = new DatabaseField(argumentFieldName);
        field.setSqlType(type);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, Class javaType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setType(javaType);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setNestedTypeField(nestedType);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, Class javaType, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(argumentFieldName);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setType(javaType);
        field.setNestedTypeField(nestedType);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setSQLString(String sqlString) {
        this.setSQLStringInternal(sqlString);
    }

    public void appendTranslationParameter(Writer writer, ParameterExpression expression, DatabasePlatform platform, AbstractRecord record) throws IOException {
        try {
            platform.writeParameterMarker(writer, expression, record);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(expression);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void useCustomSQLCursorOutputAsResultSet(String customParameterName) {
        DatabaseField field = new DatabaseField(customParameterName);
        this.getParameters().add(field);
        this.getParameterTypes().add(OUT_CURSOR);
        this.setIsCursorOutputProcedure(true);
    }
}

