/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.wls.WebLogicTransactionController;

public class WebLogicPlatform
extends ServerPlatformBase {
    protected Class weblogicConnectionClass;
    protected Method vendorConnectionMethod;

    public WebLogicPlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
    }

    public void initializeServerNameAndVersion() {
        try {
            Class clazz = PrivilegedAccessHelper.getClassForName("weblogic.version");
            Method method = PrivilegedAccessHelper.getMethod(clazz, "getBuildVersion", null, false);
            this.serverNameAndVersion = (String)PrivilegedAccessHelper.invokeMethod(method, null, null);
        }
        catch (Exception exception) {
            this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
        }
    }

    public String getApplicationName() {
        return DEFAULT_SERVER_NAME_AND_VERSION;
    }

    public Class getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = WebLogicTransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    protected Class getWebLogicConnectionClass() {
        if (this.weblogicConnectionClass == null) {
            try {
                this.weblogicConnectionClass = (Class)this.getDatabaseSession().getPlatform().convertObject("weblogic.jdbc.extensions.WLConnection", Class.class);
            }
            catch (Throwable exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
                this.weblogicConnectionClass = Void.TYPE;
            }
        }
        return this.weblogicConnectionClass;
    }

    protected Method getVendorConnectionMethod() {
        if (this.vendorConnectionMethod == null && !this.getWebLogicConnectionClass().equals(Void.TYPE)) {
            try {
                this.vendorConnectionMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebLogicConnectionClass(), "getVendorConnection", new Class[0]);
            }
            catch (NoSuchMethodException exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
            }
        }
        return this.vendorConnectionMethod;
    }

    public Connection unwrapConnection(Connection connection) {
        if (this.getWebLogicConnectionClass().isInstance(connection) && this.getVendorConnectionMethod() != null) {
            try {
                return (Connection)PrivilegedAccessHelper.invokeMethod(this.getVendorConnectionMethod(), connection);
            }
            catch (IllegalAccessException exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
            }
            catch (InvocationTargetException exception) {
                this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
            }
        }
        return super.unwrapConnection(connection);
    }
}

