/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class NamedNativeQueryMetadata
extends NamedQueryMetadata {
    private Class m_resultClass;
    private String m_resultClassName;
    private String m_resultSetMapping;

    public NamedNativeQueryMetadata() {
        super("<named-native-query>");
    }

    protected NamedNativeQueryMetadata(String javaClassName) {
        super(javaClassName);
    }

    public NamedNativeQueryMetadata(Annotation namedNativeQuery, MetadataAccessibleObject accessibleObject) {
        super(namedNativeQuery, accessibleObject);
        this.m_resultClass = (Class)MetadataHelper.invokeMethod("resultClass", namedNativeQuery);
        this.m_resultSetMapping = (String)MetadataHelper.invokeMethod("resultSetMapping", namedNativeQuery);
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedNativeQueryMetadata) {
            NamedNativeQueryMetadata query = (NamedNativeQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_resultClass, query.getResultClass())) {
                return false;
            }
            return this.valuesMatch(this.m_resultSetMapping, query.getResultSetMapping());
        }
        return false;
    }

    public Class getResultClass() {
        return this.m_resultClass;
    }

    public String getResultClassName() {
        return this.m_resultClassName;
    }

    public String getResultSetMapping() {
        return this.m_resultSetMapping;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.m_resultClass = this.initXMLClassName(this.m_resultClassName);
    }

    public void process(AbstractSession session, ClassLoader loader) {
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.m_resultClass == Void.TYPE) {
            if (this.m_resultSetMapping.equals("")) {
                session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.getQuery(), hints, loader));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.m_resultSetMapping, this.getQuery(), hints, loader));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(MetadataHelper.getClassForName(this.m_resultClass.getName(), loader), this.getQuery(), hints, loader));
        }
    }

    public void setResultClass(Class resultClass) {
        this.m_resultClass = resultClass;
    }

    public void setResultClassName(String resultClassName) {
        this.m_resultClassName = resultClassName;
    }

    protected void setResultSetMapping(String resultSetMapping) {
        this.m_resultSetMapping = resultSetMapping;
    }
}

