/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ConverterMetadata
extends AbstractConverterMetadata {
    private String m_className;

    public ConverterMetadata() {
        super("<converter>");
    }

    public ConverterMetadata(Annotation converter, MetadataAccessibleObject accessibleObject) {
        super(converter, accessibleObject);
        this.m_className = ((Class)MetadataHelper.invokeMethod("converterClass", converter)).getName();
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConverterMetadata) {
            ConverterMetadata converter = (ConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), converter.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_className, converter.getClassName());
        }
        return false;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.m_className = this.initXMLClassName(this.m_className).getName();
    }

    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        accessor.setConverterClassName(mapping, this.getClassName());
    }

    public void setClassName(String className) {
        this.m_className = className;
    }
}

