/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.sql.Blob;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicAccessor
extends DirectAccessor {
    private Boolean m_mutable;
    private ColumnMetadata m_column;
    private DatabaseField m_field;
    private GeneratedValueMetadata m_generatedValue;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private TableGeneratorMetadata m_tableGenerator;

    public BasicAccessor() {
        super("<basic>");
    }

    public BasicAccessor(String xmlElement) {
        super(xmlElement);
    }

    public BasicAccessor(Annotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        Object basic = this.getAnnotation(Basic.class);
        if (basic != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", basic));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", basic));
        }
        this.m_column = new ColumnMetadata((Annotation)this.getAnnotation(Column.class), accessibleObject, this.getAttributeName());
        Object mutable = this.getAnnotation(Mutable.class);
        if (mutable != null) {
            this.m_mutable = (Boolean)MetadataHelper.invokeMethod("value", mutable);
        }
        if (this.isAnnotationPresent(GeneratedValue.class)) {
            this.m_generatedValue = new GeneratedValueMetadata((Annotation)this.getAnnotation(GeneratedValue.class));
        }
        if (this.isAnnotationPresent(SequenceGenerator.class)) {
            this.m_sequenceGenerator = new SequenceGeneratorMetadata((Annotation)this.getAnnotation(SequenceGenerator.class), accessibleObject);
        }
        if (this.isAnnotationPresent(TableGenerator.class)) {
            this.m_tableGenerator = new TableGeneratorMetadata((Annotation)this.getAnnotation(TableGenerator.class), accessibleObject);
        }
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        if (this.m_column == null) {
            return new ColumnMetadata(this.getAccessibleObject(), this.getAttributeName());
        }
        return this.m_column;
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        DatabaseField field = super.getDatabaseField(defaultTable, loggingCtx);
        if (this.getAccessibleObject().isGenericType()) {
            field.setType(this.getReferenceClass());
        }
        return field;
    }

    public FetchType getDefaultFetchType() {
        return FetchType.EAGER;
    }

    protected DatabaseField getField() {
        return this.m_field;
    }

    public GeneratedValueMetadata getGeneratedValue() {
        return this.m_generatedValue;
    }

    public Boolean getMutable() {
        return this.m_mutable;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata(accessibleObject, this.getAttributeName());
        } else {
            this.m_column.setAttributeName(this.getAttributeName());
            this.initXMLObject(this.m_column, accessibleObject);
        }
        this.initXMLObject(this.m_sequenceGenerator, accessibleObject);
        this.initXMLObject(this.m_tableGenerator, accessibleObject);
    }

    protected boolean isCollectionClass(Class cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    protected boolean isMapClass(Class cls) {
        return Map.class.isAssignableFrom(cls);
    }

    public void process() {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        this.m_field = this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column");
        if (this.getAccessibleObject().isGenericType()) {
            mapping.setAttributeClassification(this.getReferenceClass());
        }
        mapping.setField(this.m_field);
        mapping.setIsReadOnly(this.m_field.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        this.setAccessorMethods(mapping);
        this.processMappingConverter(mapping);
        if (this.m_mutable != null) {
            mapping.setIsMutable(this.m_mutable);
        }
        this.processReturnInsertAndUpdate();
        this.processProperties(mapping);
        this.processGeneratedValue();
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator);
        }
        this.getDescriptor().addMapping(mapping);
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        if (this.isCollectionClass(this.getReferenceClass()) || this.isMapClass(this.getReferenceClass())) {
            this.processSerialized(mapping);
        } else {
            super.processEnumerated(mapping);
        }
    }

    protected void processGeneratedValue() {
        if (this.m_generatedValue != null) {
            DatabaseField existingSequenceNumberField = this.getOwningDescriptor().getSequenceNumberField();
            if (existingSequenceNumberField == null) {
                this.getOwningDescriptor().setSequenceNumberField(this.m_field);
                this.getProject().addGeneratedValue(this.m_generatedValue, this.getOwningDescriptor().getJavaClass());
            } else {
                throw ValidationException.onlyOneGeneratedValueIsAllowed(this.getOwningDescriptor().getJavaClass(), existingSequenceNumberField.getQualifiedName(), this.m_field.getQualifiedName());
            }
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (this.isCollectionClass(this.getReferenceClass()) || this.isMapClass(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.processSerialized(mapping);
        } else {
            super.processLob(mapping);
        }
    }

    protected void processReturnInsert() {
        Object returnInsert = this.getAnnotation(ReturnInsert.class);
        if (returnInsert != null) {
            boolean returnOnly = (Boolean)MetadataHelper.invokeMethod("returnOnly", returnInsert);
            if (returnOnly) {
                this.getDescriptor().addFieldForInsertReturnOnly(this.m_field);
            } else {
                this.getDescriptor().addFieldForInsert(this.m_field);
            }
        }
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getDescriptor().addFieldForUpdate(this.m_field);
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        ((DirectToFieldMapping)mapping).setConverter(converter);
    }

    public void setConverterClassName(DatabaseMapping mapping, String converterClassName) {
        ((DirectToFieldMapping)mapping).setConverterClassName(converterClassName);
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        ((DirectToFieldMapping)mapping).setFieldClassification(classification);
    }

    public void setGeneratedValue(GeneratedValueMetadata value) {
        this.m_generatedValue = value;
    }

    public void setMutable(Boolean mutable) {
        this.m_mutable = mutable;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        this.m_sequenceGenerator = sequenceGenerator;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGenerator) {
        this.m_tableGenerator = tableGenerator;
    }
}

