/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapEnumeration;
import org.eclipse.persistence.internal.identitymaps.IdentityMapKeyEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullIdentityMap
extends AbstractIdentityMap {
    protected Map<CacheKey, CacheKey> cacheKeys;

    public FullIdentityMap() {
    }

    public FullIdentityMap(int size) {
        super(size);
        this.cacheKeys = new ConcurrentHashMap<CacheKey, CacheKey>(size);
    }

    public FullIdentityMap(int size, ClassDescriptor descriptor) {
        super(size, descriptor);
        this.cacheKeys = new ConcurrentHashMap<CacheKey, CacheKey>(size);
    }

    @Override
    public Object clone() {
        FullIdentityMap clone = (FullIdentityMap)super.clone();
        clone.setCacheKeys(new ConcurrentHashMap<CacheKey, CacheKey>(this.getCacheKeys().size()));
        Iterator<CacheKey> cacheKeysIterator = this.getCacheKeys().values().iterator();
        while (cacheKeysIterator.hasNext()) {
            CacheKey key = (CacheKey)cacheKeysIterator.next().clone();
            clone.getCacheKeys().put(key, key);
        }
        return clone;
    }

    @Override
    public void collectLocks(HashMap threadList) {
        for (CacheKey cacheKey : this.getCacheKeys().values()) {
            if (!cacheKey.isAcquired()) continue;
            Thread activeThread = cacheKey.getMutex().getActiveThread();
            HashSet<CacheKey> set = (HashSet<CacheKey>)threadList.get(activeThread);
            if (set == null) {
                set = new HashSet<CacheKey>();
                threadList.put(activeThread, set);
            }
            set.add(cacheKey);
        }
    }

    @Override
    public Enumeration elements() {
        return new IdentityMapEnumeration(this);
    }

    @Override
    protected CacheKey getCacheKey(CacheKey searchKey) {
        return this.getCacheKeys().get(searchKey);
    }

    @Override
    protected CacheKey getCacheKeyIfAbsentPut(CacheKey searchKey) {
        CacheKey cacheKey = this.getCacheKeys().get(searchKey);
        if (cacheKey == null) {
            searchKey.setOwningMap(this);
            cacheKey = ((ConcurrentMap)this.getCacheKeys()).putIfAbsent(searchKey, searchKey);
        }
        return cacheKey;
    }

    public Map<CacheKey, CacheKey> getCacheKeys() {
        return this.cacheKeys;
    }

    @Override
    public int getSize() {
        return this.cacheKeys.size();
    }

    @Override
    public int getSize(Class myClass, boolean recurse) {
        int count = 0;
        for (CacheKey key : this.getCacheKeys().values()) {
            Object object = key.getObject();
            if (object == null) continue;
            if (recurse && myClass.isInstance(object)) {
                ++count;
                continue;
            }
            if (!object.getClass().equals(myClass)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Enumeration keys() {
        return new IdentityMapKeyEnumeration(this);
    }

    @Override
    public CacheKey put(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, object, writeLockValue, readTime);
        CacheKey cacheKey = this.getCacheKeyIfAbsentPut(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        this.resetCacheKey(cacheKey, object, writeLockValue, readTime);
        return cacheKey;
    }

    @Override
    public Object remove(CacheKey cacheKey) {
        if (cacheKey != null) {
            cacheKey.acquire();
            this.getCacheKeys().remove(cacheKey);
            cacheKey.release();
            return cacheKey.getObject();
        }
        return null;
    }

    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue, long readTime) {
        key.acquire();
        key.setObject(object);
        key.setWriteLockValue(writeLockValue);
        key.setReadTime(readTime);
        key.release();
    }

    protected void setCacheKeys(Map<CacheKey, CacheKey> cacheKeys) {
        this.cacheKeys = cacheKeys;
    }
}

