/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentReadOnInsertTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentReadOnUpdateWithEarlyTransTest;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentRefreshOnCloneTest;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class ConcurrentAddress
implements Serializable,
Cloneable {
    public BigDecimal id;
    public String street = "";
    public String city = "";
    public String province = "";
    public String postalCode = "";
    public String country = "";
    public static int RUNNING_TEST;
    public static final int NONE = Integer.MIN_VALUE;
    public static final int LOCK_ON_CLONE_TEST = 55;
    public static final int LOCK_ON_CLONE_DEADLOCK = 56;
    public static final int READ_ON_UPDATE_EARLY_TRANS = 57;
    public static boolean isForBackup;

    public Object clone() {
        ConcurrentAddress result = new ConcurrentAddress();
        result.id = this.id;
        result.city = this.city;
        result.province = this.province;
        result.postalCode = this.postalCode;
        result.street = this.street;
        result.country = this.country;
        return result;
    }

    public String getCity() {
        return this.city;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCountry() {
        block9: {
            try {
                if (ConcurrentRefreshOnCloneTest.lock == null) break block9;
                ConcurrentAddress concurrentAddress = ConcurrentRefreshOnCloneTest.lock;
                synchronized (concurrentAddress) {
                    if (!ConcurrentRefreshOnCloneTest.waited) {
                        if (ConcurrentRefreshOnCloneTest.readerWaiting) {
                            ConcurrentRefreshOnCloneTest.lock.notifyAll();
                            Thread.yield();
                        }
                        if (((AbstractSession)ConcurrentRefreshOnCloneTest.session).getIdentityMapAccessorInstance().getIdentityMapManager().getCacheMutex().getActiveThread() != Thread.currentThread()) {
                            ConcurrentRefreshOnCloneTest.cloneWaiting = true;
                            ConcurrentRefreshOnCloneTest.lock.wait(30000L);
                            ConcurrentRefreshOnCloneTest.cloneWaiting = false;
                        } else {
                            Thread.sleep(4000L);
                        }
                        ConcurrentRefreshOnCloneTest.waited = true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.country;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProvince() {
        if (RUNNING_TEST == 55 || RUNNING_TEST == 56) {
            if (!isForBackup) {
                ConcurrentAddress concurrentAddress = this;
                synchronized (concurrentAddress) {
                    isForBackup = true;
                    this.notifyAll();
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            isForBackup = false;
        }
        return this.province;
    }

    public String getStreet() {
        return this.street;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setId(BigDecimal id) {
        block11: {
            try {
                if (RUNNING_TEST == 57) {
                    if (!ConcurrentReadOnUpdateWithEarlyTransTest.threadId.get().equals("Writer")) break block11;
                    ConcurrentAddress concurrentAddress = ConcurrentReadOnUpdateWithEarlyTransTest.readAddress;
                    synchronized (concurrentAddress) {
                        ConcurrentReadOnUpdateWithEarlyTransTest.readAddress.notify();
                        ConcurrentReadOnUpdateWithEarlyTransTest.whosWaiting = 1;
                        ConcurrentReadOnUpdateWithEarlyTransTest.readAddress.wait(30000L);
                        break block11;
                    }
                }
                if (ConcurrentReadOnInsertTest.readAddress == null) break block11;
                ConcurrentAddress concurrentAddress = ConcurrentReadOnInsertTest.readAddress;
                synchronized (concurrentAddress) {
                    if (ConcurrentReadOnInsertTest.depth <= 0) {
                        ConcurrentReadOnInsertTest.readAddress.notifyAll();
                    } else {
                        --ConcurrentReadOnInsertTest.depth;
                    }
                }
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.id = id;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Address: ");
        writer.write(this.street);
        writer.write(", ");
        writer.write(this.city);
        writer.write(", ");
        writer.write(this.province);
        writer.write(", ");
        writer.write(this.country);
        return writer.toString();
    }

    public static TableDefinition tableDefinition() {
        TableDefinition tabledefinition = new TableDefinition();
        tabledefinition.setName("CONCURRENT_ADDRESS");
        FieldDefinition field = new FieldDefinition();
        field.setName("ADDRESS_ID");
        field.setTypeName("NUMERIC");
        field.setSize(15);
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(true);
        field.setUnique(false);
        field.setIsIdentity(true);
        tabledefinition.addField(field);
        FieldDefinition field1 = new FieldDefinition();
        field1.setName("P_CODE");
        field1.setTypeName("VARCHAR");
        field1.setSize(20);
        field1.setShouldAllowNull(true);
        field1.setIsPrimaryKey(false);
        field1.setUnique(false);
        field1.setIsIdentity(false);
        tabledefinition.addField(field1);
        FieldDefinition field2 = new FieldDefinition();
        field2.setName("CITY");
        field2.setTypeName("VARCHAR");
        field2.setSize(80);
        field2.setShouldAllowNull(true);
        field2.setIsPrimaryKey(false);
        field2.setUnique(false);
        field2.setIsIdentity(false);
        tabledefinition.addField(field2);
        FieldDefinition field3 = new FieldDefinition();
        field3.setName("PROVINCE");
        field3.setTypeName("VARCHAR");
        field3.setSize(80);
        field3.setShouldAllowNull(true);
        field3.setIsPrimaryKey(false);
        field3.setUnique(false);
        field3.setIsIdentity(false);
        tabledefinition.addField(field3);
        FieldDefinition field4 = new FieldDefinition();
        field4.setName("STREET");
        field4.setTypeName("VARCHAR");
        field4.setSize(80);
        field4.setShouldAllowNull(true);
        field4.setIsPrimaryKey(false);
        field4.setUnique(false);
        field4.setIsIdentity(false);
        tabledefinition.addField(field4);
        FieldDefinition field5 = new FieldDefinition();
        field5.setName("COUNTRY");
        field5.setTypeName("VARCHAR");
        field5.setSize(80);
        field5.setShouldAllowNull(true);
        field5.setIsPrimaryKey(false);
        field5.setUnique(false);
        field5.setIsIdentity(false);
        tabledefinition.addField(field5);
        return tabledefinition;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(ConcurrentAddress.class);
        descriptor.addTableName("CONCURRENT_ADDRESS");
        descriptor.addPrimaryKeyFieldName("CONCURRENT_ADDRESS.ADDRESS_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("CONCURRENT_ADDRESS.CITY");
        cityMapping.setWeight(Integer.valueOf(10));
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("CONCURRENT_ADDRESS.COUNTRY");
        countryMapping.setSetMethodName("setCountry");
        countryMapping.setGetMethodName("getCountry");
        countryMapping.setWeight(Integer.valueOf(9));
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CONCURRENT_ADDRESS.ADDRESS_ID");
        idMapping.setSetMethodName("setId");
        idMapping.setGetMethodName("getId");
        idMapping.setWeight(Integer.valueOf(8));
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("CONCURRENT_ADDRESS.P_CODE");
        postalCodeMapping.setWeight(Integer.valueOf(7));
        descriptor.addMapping((DatabaseMapping)postalCodeMapping);
        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("CONCURRENT_ADDRESS.PROVINCE");
        provinceMapping.setSetMethodName("setProvince");
        provinceMapping.setGetMethodName("getProvince");
        provinceMapping.setWeight(Integer.valueOf(6));
        descriptor.addMapping((DatabaseMapping)provinceMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("CONCURRENT_ADDRESS.STREET");
        streetMapping.setWeight(Integer.valueOf(5));
        descriptor.addMapping((DatabaseMapping)streetMapping);
        return descriptor;
    }

    static {
        isForBackup = false;
    }
}

