/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.math.BigDecimal;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPerson;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPhoneNumber;

public class ConcurrentReadFetchJoinTest
extends AutoVerifyTestCase {
    public static final String NUMBER_TYPE = "cell";
    protected BigDecimal personId = null;
    protected BigDecimal projectId = null;
    protected ConcurrentPerson person = null;
    protected boolean deadlockDetected = false;

    public void setup() {
        this.deadlockDetected = false;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.person = new ConcurrentPerson();
        this.person.name = "Wenger";
        ConcurrentPhoneNumber phoneNumber = new ConcurrentPhoneNumber();
        phoneNumber.setType(NUMBER_TYPE);
        phoneNumber.setNumber("1234567");
        phoneNumber.setOwner(this.person);
        this.person.phoneNumbers.add(phoneNumber);
        uow.registerObject((Object)this.person);
        uow.registerObject((Object)phoneNumber);
        uow.commit();
        uow.release();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.personId = this.person.id;
    }

    public void test() {
        block4: {
            ConcurrentPerson.RUNNING_TEST = ConcurrentPerson.READ_FETCH_JOIN;
            Thread thread1 = new Thread(new PersonReader(this.getSession().acquireUnitOfWork(), this.personId));
            Thread thread2 = new Thread(new PhoneNumberReader(this.getSession().acquireUnitOfWork(), this.personId, NUMBER_TYPE));
            thread1.start();
            thread2.start();
            try {
                thread1.join(30000L);
                if (!thread1.isAlive()) break block4;
                try {
                    thread1.interrupt();
                    thread2.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deadlockDetected = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void verify() {
        if (this.deadlockDetected) {
            throw new TestErrorException("Deadlock detected when reading a bidirectional relationship with a fetch join.");
        }
    }

    public void reset() {
        ConcurrentPerson.RUNNING_TEST = Integer.MIN_VALUE;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.person.getPhoneNumbers().get(0));
        uow.deleteObject((Object)this.person);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public class PersonReader
    implements Runnable {
        private UnitOfWork uow;
        private BigDecimal id;

        public PersonReader(UnitOfWork uow, BigDecimal id) {
            this.uow = uow;
            this.id = id;
        }

        @Override
        public void run() {
            this.uow.readObject(ConcurrentPerson.class, new ExpressionBuilder().get("id").equal((Object)this.id));
        }
    }

    public class PhoneNumberReader
    implements Runnable {
        private UnitOfWork uow;
        private BigDecimal id;
        private String type;

        public PhoneNumberReader(UnitOfWork uow, BigDecimal id, String type) {
            this.uow = uow;
            this.id = id;
            this.type = type;
        }

        @Override
        public void run() {
            ReadObjectQuery query = new ReadObjectQuery(ConcurrentPhoneNumber.class);
            ExpressionBuilder phoneNumberBuilder = query.getExpressionBuilder();
            Expression exp = phoneNumberBuilder.get("type").equal((Object)this.type).and(phoneNumberBuilder.get("owner").get("id").equal((Object)this.id));
            query.setSelectionCriteria(exp);
            query.addJoinedAttribute("owner");
            this.uow.executeQuery((DatabaseQuery)query);
        }
    }
}

