/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.tests.returning.ProjectAndDatabaseAdapter;
import org.eclipse.persistence.testing.tests.returning.TestSystemAdapted;

public class TestModelAdapted
extends TestModel {
    protected ProjectAndDatabaseAdapter adapter;
    protected TestModel testModel;
    protected String[] testNamesToExclude;

    public TestModelAdapted() {
    }

    public TestModelAdapted(TestModel testModelToBeAdapted, ProjectAndDatabaseAdapter adapter) {
        this();
        this.setTestModel(testModelToBeAdapted);
        Vector testsToAdd = (Vector)this.getTestModel().getTests().clone();
        for (int i = 0; i < testsToAdd.size(); ++i) {
            TestEntity testEntity = (TestEntity)testsToAdd.elementAt(i);
            testEntity.setContainer((TestEntity)this);
        }
        this.getTestModel().getTests().clear();
        this.setAdapter(adapter);
        this.setName(this.getTestModel().getName() + " using " + Helper.getShortClassName((Object)this.getAdapter()));
    }

    public TestModelAdapted(TestModel testModelToBeAdapted, ProjectAndDatabaseAdapter adapter, String[] testNamesToExclude) {
        this(testModelToBeAdapted, adapter);
        this.setTestNamesToExclude(testNamesToExclude);
    }

    public TestModelAdapted(TestModel testModelToBeAdapted, ProjectAndDatabaseAdapter adapter, String testNameToExclude) {
        this(testModelToBeAdapted, adapter, new String[1]);
        this.getTestNamesToExclude()[0] = testNameToExclude;
    }

    public void setAdapter(ProjectAndDatabaseAdapter adapter) {
        this.adapter = adapter;
    }

    public ProjectAndDatabaseAdapter getAdapter() {
        return this.adapter;
    }

    public void setTestModel(TestModel testModelToBeAdapted) {
        this.testModel = testModelToBeAdapted;
    }

    public TestModel getTestModel() {
        return this.testModel;
    }

    public void setTestNamesToExclude(String[] testNamesToExclude) {
        this.testNamesToExclude = testNamesToExclude;
    }

    public String[] getTestNamesToExclude() {
        return this.testNamesToExclude;
    }

    public void addForcedRequiredSystems() {
        Vector systems = this.getTestModel().buildForcedRequiredSystems();
        for (int i = 0; i < systems.size(); ++i) {
            TestSystemAdapted testSystemAdapted = new TestSystemAdapted((TestSystem)systems.elementAt(i), this.getAdapter());
            this.addForcedRequiredSystem(testSystemAdapted);
        }
    }

    public void addRequiredSystems() {
        Vector systems = this.getTestModel().buildRequiredSystems();
        for (int i = 0; i < systems.size(); ++i) {
            TestSystemAdapted testSystemAdapted = new TestSystemAdapted((TestSystem)systems.elementAt(i), this.getAdapter());
            this.addRequiredSystem(testSystemAdapted);
        }
    }

    public void reset() {
        this.getExecutor().removeConfigureSystem((TestSystem)new TestSystemAdapted());
    }

    public void addTests() {
        this.getTestModel().addTests();
        Vector testsToAdd = (Vector)this.getTestModel().getTests().clone();
        for (int i = 0; i < testsToAdd.size(); ++i) {
            TestEntity testEntity = (TestEntity)testsToAdd.elementAt(i);
            testEntity.setContainer((TestEntity)this);
        }
        this.getTestModel().getTests().clear();
        this.addTests(testsToAdd);
        if (this.shouldExcludeTests()) {
            this.excludeTests((TestCollection)this);
        }
    }

    protected boolean shouldExcludeTests() {
        return this.getTestNamesToExclude() != null && this.getTestNamesToExclude().length != 0;
    }

    protected String excludeTests(TestCollection testCollection) {
        Object suffix = "";
        Vector tests = testCollection.getTests();
        for (int i = tests.size() - 1; i >= 0; --i) {
            TestEntity testEntity = (TestEntity)tests.elementAt(i);
            if (this.shouldBeExcluded(testEntity)) {
                tests.removeElementAt(i);
                suffix = (String)suffix + testEntity.getName() + " ";
                continue;
            }
            if (!(testEntity instanceof TestCollection)) continue;
            suffix = (String)suffix + this.excludeTests((TestCollection)testEntity);
        }
        if (((String)suffix).length() != 0) {
            testCollection.setName(testCollection.getName() + " without " + (String)suffix);
        }
        return suffix;
    }

    protected boolean shouldBeExcluded(TestEntity testEntity) {
        for (int i = 0; i < this.testNamesToExclude.length; ++i) {
            if (!testEntity.getName().equals(this.testNamesToExclude[i])) continue;
            return true;
        }
        return false;
    }

    public void setExecutor(TestExecutor anExecutor) {
        super.setExecutor(anExecutor);
        this.getTestModel().setExecutor(anExecutor);
    }
}

