/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UpdateAllQueryRollbackTest
extends TestCase {
    private Session m_session;
    private boolean m_exceptionCaught;
    private UnitOfWork m_uow;

    public void reset() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.m_session = this.getSession();
        this.m_exceptionCaught = false;
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        this.m_uow = this.m_session.acquireUnitOfWork();
        ExpressionBuilder eb = new ExpressionBuilder();
        UpdateAllQuery uaq1 = new UpdateAllQuery(Employee.class);
        uaq1.addUpdate(eb.get("lastName"), (Object)"shouldRollback");
        this.m_uow.executeQuery((DatabaseQuery)uaq1);
        UpdateAllQuery uaq2 = new UpdateAllQuery(Employee.class);
        uaq2.addUpdate(eb.getField("BAD"), (Object)10000);
        this.m_uow.executeQuery((DatabaseQuery)uaq2);
        try {
            this.m_uow.commit();
        }
        catch (Exception e) {
            this.m_exceptionCaught = true;
        }
    }

    protected void verify() {
        if (this.m_exceptionCaught) {
            Vector emps = this.m_session.readAllObjects(Employee.class);
            for (int i = 0; i < emps.size(); ++i) {
                Employee emp = (Employee)emps.elementAt(i);
                if (!emp.getLastName().equals("shouldRollback")) continue;
                throw new TestErrorException("Update all did not rollback on commit failure");
            }
        } else {
            throw new TestWarningException("Test did not catch an exception.");
        }
    }
}

