/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class StoredProcedureTest2
extends TestCase {
    DatabaseRecord row;
    int id = 1;
    boolean shouldBindAllParameters;

    public StoredProcedureTest2() {
        this(true);
    }

    public StoredProcedureTest2(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters;
        this.setName(this.getName() + " bind = " + shouldBindAllParameters);
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test can only be run in Oracle");
        }
    }

    public void test() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("StoredProcedure_InOutput2");
        call.addNamedInOutputArgument("P_ID");
        call.addNamedOutputArgument("P_ID2", "P_ID2", Integer.class);
        DataReadQuery query = new DataReadQuery();
        query.setShouldBindAllParameters(this.shouldBindAllParameters);
        query.setCall((Call)call);
        query.addArgument("P_ID");
        Vector<Integer> args = new Vector<Integer>(1);
        args.addElement(this.id);
        this.row = (DatabaseRecord)((Vector)this.getSession().executeQuery((DatabaseQuery)query, args)).firstElement();
    }

    public void verify() {
        int id1 = ((Number)this.row.get("P_ID")).intValue();
        int id2 = ((Number)this.row.get("P_ID2")).intValue();
        if (id1 != this.id) {
            throw new TestErrorException("Invalid value P_ID = " + id1 + "; should be " + this.id);
        }
        if (id2 != this.id * 2) {
            throw new TestErrorException("Invalid value P_ID2 = " + id2 + "; should be " + this.id * 2);
        }
    }
}

